#!/usr/bin/perl
use strict;
use warnings;
use utf8;

# $Id$

use Test::Deep;
use Test::More;
use Test::Exception;
use Test::Mock::LWP;

use Readonly;

use Yandex::Passport;

$Yandex::Passport::SERVICE_NAME_IN_PASSPORT = 'slova';

Readonly my $FIRST_NAME => 'Андрей';
Readonly my $LAST_NAME  => 'Макарский';
Readonly my $LOGIN      => 'amakarskiy';
Readonly my $PASSWORD   => '12345';
Readonly my $UID        => 230306469;

Readonly my $VALID_OK_RESPONSE => qq!{"status":"ok","uid":$UID}!;
Readonly my $VALID_OCCUPIED_RESPONSE => '{"status":"error","error":["account.already_registered"]}';
Readonly my $VALID_ERROR_RESPONSE => '{"status":"error","error":["firstname.empty","password.prohibitedsymbols","login.startswithdigit"]}';
Readonly my $INVALID_RESPONSE => <<"ENDRESPONSE";
<!DOCTYPE html PUBLIC "-W3CDTD XHTML 1.0 TransitionalEN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html class="i-ua_js_no i-ua_css_standard">
</html>
ENDRESPONSE

my @tests = (
    # [$_mock_resp_args], $expected_result, $test_name
    [[$VALID_OK_RESPONSE], {status => 'ok', uid => $UID}, 'login successfully created'],
    [[$VALID_OCCUPIED_RESPONSE], {status => 'error', error => ['account.already_registered']}, 'login already exists'],
    [[$VALID_ERROR_RESPONSE], {status => 'error', error => ['firstname.empty','password.prohibitedsymbols','login.startswithdigit']}, 'error in data'],
);


sub _mock {
    my ($resp_text, %O) = @_;

    my %mock_resp_data = (
        code => 200,
        is_error => 0,
        is_success => 1,
        status_line => '200 OK',
        content_type => $O{content_type} || 'application/json',
        content => $resp_text,
        decoded_content => $resp_text,
    );
    while (my($name, $val) = each %mock_resp_data) {
        $Mock_response->mock($name => sub { return $val });
    }

    $Mock_ua->mock(post => sub { return $Mock_response });
#    $Mock_request->mock(content => sub {});
}

dies_ok { Yandex::Passport::create_passport_login() } 'bogus params';

for my $test (@tests) {
    my ($mock_resp_args, $expected_result, $test_name) = @$test;
    _mock(@$mock_resp_args);
    my $result = Yandex::Passport::create_passport_login( $LOGIN, $FIRST_NAME, $LAST_NAME, $PASSWORD );
    cmp_deeply($result, $expected_result, $test_name);
}

_mock($INVALID_RESPONSE, content_type => 'text/html');
dies_ok { Yandex::Passport::create_passport_login( $LOGIN, $FIRST_NAME, $LAST_NAME, $PASSWORD ) } 'invalid response';

done_testing;
