package Yandex::PerlIO::via::Truncate;

# $Id$

=head1 NAME

    Yandex::PerlIO::via::Truncate

=head1 DESCRIPTION

    Фильтр для обрезания данных, выводимых в файл.
    Может работать только для одного хэндла за одно выполнение программы

=head1 SYNOPSIS

    use Yandex::PerlIO::via::Truncate;
    sub handler {
        my $r = shift;
        Yandex::PerlIO::via::Truncate::init(\*STDERR, 1_000_000);
        ...
    }

=cut

use strict;
use warnings;

=head2 $Yandex::PerlIO::via::Truncate::TRUNCATE_TEXT = ' truncated...'

    Какой текст нужно вывести, когда выхли за указанные пределы

=cut
our $TRUNCATE_TEXT = " truncated...\n";

# флаг, сделали ли мы уже binmode
my $_inited = 0;

# умолчательное значение ограничения на объём записываемых данных
my $limit = 1_000_000;

# счётчики числа записанных и прочитанных файлов
my $_readed = 0;
my $_writed = 0;
my $_write_truncated = 0;

=head2 Yandex::PerlIO::via::Truncate::init($fh, $limit=1e6)

    При первом вызове - установить на $fh layer,
    при повторных вызовах сбрасывать счётчики.

=cut
sub init {
    if (!$_inited) {
        binmode($_[0], ":via(Yandex::PerlIO::via::Truncate):utf8");
        $_inited = 1;
    }
    $limit = $_[1] if defined $_[1];
    $_readed = $_writed = 0;
    $_write_truncated = 0;
}

# заявить поддержку utf8
sub UTF8 {
    return 1;
}

# конструктор, вызываемый в момент binmode
sub PUSHED { 
    my ($class) = @_;
    bless {};
}

# чтение из файла
sub FILL {
    my ($self, $fh) = shift;
    if (defined(my $line = readline($fh))) {
        my $max_len = $limit > $_readed ? $limit - $_readed : 0;
        $_readed += length($line);
        return substr($line, 0, $max_len);
    }
    undef;
}

# запись в файл
sub WRITE {
    my ($self, $buf, $fh) = @_;
    my $max_len = $limit > $_writed ? $limit - $_writed : 0;
    $_writed += length($buf);
    print $fh substr($buf, 0, $max_len);
    if ($max_len < length($buf) && !$_write_truncated) {
        print $fh $TRUNCATE_TEXT;
        $_write_truncated = 1;
    }
    return length($buf);
}

1;
