package Yandex::ProcInfo;

=pod
    $Id$
    Получение системной информации о процесе. На текущий момент только занимаемая память.
    
    Удобных аналогов на CPAN не нашлось: 
        либо много зависимостей GTop
        либо чтение данных для всех процесов Proc::ProcessTable
=cut

use strict;
use warnings;

require Exporter;
our @ISA = qw/Exporter/;
our @EXPORT = qw/
        proc_memory
        proc_status
        proc_status_str
        proc_check_memsize
        /;
 
# преобразовать "123 kb" в байты       
sub proc_convert_mem_info($) {
    my $str = shift;
    return undef if !defined $str;
    if ($str =~ /^(\d+)\s*kb?\s*$/i) {
        return 1024 * $1;
    } elsif ($str =~ /^(\d+)\s*mb?\s*$/i) {
        return 1024 * 1024 * $1;
    } elsif ($str =~ /^(\d+)\s*gb?\s*$/i) {
        return 1024 * 1024 * 1024 * $1;
    } else {
        die "Unknown memory info format: '$str'";
    }
}

# вернуть объём памяти, занимаемой процессом
sub proc_memory(;$) {
    my $stat = proc_status(@_);
    die "No VmRSS field in /proc/PID/status" if !defined $stat->{VmRSS};
    return proc_convert_mem_info($stat->{VmRSS});
}

# чтение и парсинг файла /proc/PID/status
sub proc_status(;$) {
    my $pid = shift || $$;
    my $file = "/proc/$pid/status";
    open(my $fd, "<", $file) || die "Can't open file '$file': $!";
    my %status;
    local $_; # Защита переменной
    local $/ = "\n";
    while(<$fd>) {
        if (/^(\w+):\s+(.+)/) {
            $status{$1} = $2;
        }
    }
    return \%status;
} 

# делаем проверку на размер, если выросли больше чем нужно - перезапускаемся
# граница передаётся как параметр. по-умолчанию - 1GB
sub proc_check_memsize(;$) {
    my $memmax = shift || 1*1024*1024*1024;
    my $mem = proc_memory();
    if ($mem > $memmax) {
        die "Process used memory more than $memmax, let's restart";
    }
}

# Выдать строчку с информацией о процессе.
sub proc_status_str {
    my $mem = proc_memory();
    my ($cpu_user, $cpu_sys) = times;
    return sprintf("Status: memory=%dMb, cpu_user=%0.2f, cpu_sys=%0.2f", $mem / 1024 / 1024, $cpu_user, $cpu_sys);
}

1;
