use strict;
use warnings;

package Yandex::Profile::Parse;

=head2 NAME

    Yandex::Profile::Parse

=head2 DESCRIPTION

=cut

use base qw/Exporter/;
our @EXPORT = qw/parse_profile_line parse_profile_line_reqid/;

=head2 parse_profile_line($str)

    Парсит одну строку из profile.log, возвращает сложный хэш
    со всеми данными.

    При ошибке возвращает undef.

=cut
sub parse_profile_line {
    my ($str) = @_;

    my ($date, $time, $cmd_type, $cmd, $reqid, $totals, $calls) = 
        $str =~ /^
                (\d{4}-\d{2}-\d{2}) \t 
                (\d{2}:\d{2}:\d{2}) \t
                ([^\-\t\/]+) (?: \/ ([^\t]+) )? \t
                (\d+) \t
                (\w+:[\d\.]+(?:,\w+:[\d\.]+)*) 
                \t? (.*)
                $
                /xo;

    return undef if !$date;

    my %ret = (
        dt => "$date $time",
        cmd_type => $cmd_type,
        cmd => $cmd||'-',
        reqid => $reqid,
        totals => {split /[:,]/, $totals},
        calls => [],
        );
    for my $call (split /\t/, $calls) {
        my ($func, $param, $ela, $cnt, $obj_num) = 
            $call =~ /^ (\S*) \# (\S*): \s ([\d\.]+) \/ (\d+) (?:\/(\d+))? \s* $/xo;
        return undef if !$func;
        push @{$ret{calls}}, {
            func => $func,
            param => $param,
            ela => $ela,
            cnt => $cnt,
            obj_num => $obj_num || 0,
            };
    }

    return \%ret;
}

=head2 parse_profile_line_reqid($str)

    Быстрый способ получить из строки profile_log-а только reqid
    Формат строки не проверяется.

=cut
sub parse_profile_line_reqid {
    return (split /\t/, $_[0])[3];
}

1;
