#!/usr/bin/perl -w

use strict;
use warnings;
use Test::More;
use Test::Deep;
use Data::Dumper;

use Yandex::Profile::Parse;

*pp = \&parse_profile_line;
*ppr = \&parse_profile_line_reqid;

is(pp("Asdfewrg"), undef);

my $str = "2012-12-13\t16:24:11\tCmd/showCamps\t14540129172842299960\ttotal:0.753,u:0.560,s:0.020,cu:0.000,cs:0.000,mem:0\tYandex::Template::Profile::Service::process#: 0.288/1/0\tYandex::DBTools::_sth_execute#db=ppc~read: 0.126/305/0";

is(ppr($str), 14540129172842299960);

cmp_deeply(pp($str), {
          'dt' => '2012-12-13 16:24:11',
          'cmd_type' => 'Cmd',
          'cmd' => 'showCamps',
          'reqid' => '14540129172842299960',
          'totals' => {
                        'u' => '0.560',
                        'cu' => '0.000',
                        'cs' => '0.000',
                        'mem' => '0',
                        's' => '0.020',
                        'total' => '0.753'
                      },
          'calls' => [
                       {
                         'ela' => '0.288',
                         'obj_num' => 0,
                         'func' => 'Yandex::Template::Profile::Service::process',
                         'param' => '',
                         'cnt' => '1'
                       },
                       {
                         'ela' => '0.126',
                         'obj_num' => 0,
                         'func' => 'Yandex::DBTools::_sth_execute',
                         'param' => 'db=ppc~read',
                         'cnt' => '305'
                       }
                     ],
        }
);


done_testing();
