package Yandex::Pushkin;

=pod

    $Id$
    Модуль/обёртка вокруг XMLRPC вызовов сервиса push уведомлений Pushkin

=cut

use strict;
use warnings;
use XMLRPC::Lite;
use XML::Simple;
use SOAP::Lite;
use Data::Dumper;

use Yandex::XMLRPC::UTF8Serializer;
use Yandex::Log;
use Yandex::Trace;
use Yandex::Retry;

use base qw/Exporter/;

use utf8;

our $DEBUG;

our @EXPORT = qw/
    pushkin_add_iOS_token
    pushkin_remove_iOS_token
    pushkin_mass_send_pushes
/;

our $PUSHKIN_XMLRPC ||= 'http://pusher.yandex.net/';
our $TIMEOUT ||= 5;
our $DIRECT_APP_ID ||= 'ru.yandex.direct';
our $RETRIES ||= 2;

our %PUSHKIN_CALLS_LOG_SETTINGS;
%PUSHKIN_CALLS_LOG_SETTINGS = (
    log_file_name => "pushkin_calls.log",
    date_suf => "%Y%m%d",
) if !%PUSHKIN_CALLS_LOG_SETTINGS;

=head2

    Вызов Пушкина

=cut

#TODO: По хорошему надо бы объединить эту функцию с аналогичной в Yandex::Balance, вынести в модуль, вроде Yandex::XMLRPCClient
sub pushkin_call {
    my ($method, $params) = @_;

    my $log = new Yandex::Log(
        %PUSHKIN_CALLS_LOG_SETTINGS,
        msg_prefix => "[$$]",
    );

    my $profile = Yandex::Trace::new_profile("pushkin:$method");

    $log->out({"$method call" => $params});

    $params = encode_to_str($params);

    # вызов метода
    my $rpc = XMLRPC::Lite->proxy($PUSHKIN_XMLRPC, $TIMEOUT)
        -> serializer( new Yandex::XMLRPC::UTF8Serializer('utf8') )
        -> deserializer( new Yandex::XMLRPC::UTF8Deserializer('utf8') );

    if ($DEBUG) {
        $rpc -> on_debug(sub {print @_});
    }

    my $rpc_res;

    retry tries => $RETRIES, sub {
        $rpc_res = eval { $rpc->call($method, @$params); };

        # проверка всяческих ошибок
        my $error;
        if ($@) {
            $error = "$method died - $@";
        } elsif (!defined $rpc_res) {
            $error = "$method returned undef";
        } elsif ($rpc_res->fault) {
            $error = "$method fault - ".join(', ', $rpc_res->faultcode, $rpc_res->faultstring, $rpc_res->faultdetail);
        }
        if ($error) {
            $log->die($error);
        }
    }; # /retry

    # получение результата
    my @ret = $rpc_res->paramsall();
    $log->out({"$method return" => \@ret});

    return @ret;
}

sub encode_to_str {
    my $params = shift;

    if (ref($params) eq 'ARRAY') {
        return [map {encode_to_str($_)} @$params];
    } elsif (ref($params) eq 'HASH') {
        return {map {$_ => encode_to_str($params->{$_})} keys %$params};
    } elsif (!ref($params)) {
        if (defined $params && ($params eq 'true' || $params eq 'false')) {
            return SOAP::Data->type('boolean' => $params);
        } elsif ($params) {
            return SOAP::Data->type('string' => $params);
        }
    }
}

=head2 pushkin_add_iOS_token

    Регистрирует новый iOS токен
    input: uid в паспорте, push_token
    output: 1

=cut

sub pushkin_add_iOS_token {
    my ($uid, $push_token, $options) = @_;

    my @add_options;

    if (defined $options) {
        push @add_options, $options;
    }

    my ($res) = eval {pushkin_call('v1.add_iOS_token', [$DIRECT_APP_ID, $uid, $push_token, 'true', @add_options])};

    if ($@) {
        if ($@ =~ /(malformed token)/) {
            return $1;
        }
        die {message => Dumper($@), dont_alert => 1};
    }
    return $res;
}

=head2 pushkin_remove_iOS_token
    
    Удаляет iOS токен
    input: push_token
    outout: 1

=cut

sub pushkin_remove_iOS_token {
    my ($push_token) = @_;

    my ($res) = pushkin_call('v1.remove_iOS_token', [$DIRECT_APP_ID, $push_token]);

    return $res;
}

=head2 pushkin_push_message
    
    Отправить push нотификацию на все устройства пользователя
    input: uid в паспорте, message
    ounput: количество отправленных пушей
    
=cut

sub pushkin_push_message {
    my ($uid, $message, $payload) = @_;
    $payload ||= {};

    my ($res) = pushkin_call('v1.push_message', [$DIRECT_APP_ID, $uid, $message, $payload]);

    return $res;
}

=head2 pushkin_push_message
    
    Отправить push нотификации на утсройства пользователей
    input: массив messages в формате [oid, uid, message]
    ounput: для каждого сообщения возвращает 1 или 0 (отправлено или нет, соответственно), или -1 (ошибка)
    
=cut

sub pushkin_mass_send_pushes {
    my @messages = @_;

    my @result;

    while(my @chunk = splice @messages, 0, 50) {
        my $request;

        foreach my $message (@chunk) {
            push @$request, {methodName => 'v1.push_message_oid', params => $message};
        }

        my ($res) = eval { pushkin_call('system.multicall', [$request]) };
        for (my $i = 0; $i < scalar @chunk; $i++) {
            push @result, ($res && ref($res->[$i]) eq 'ARRAY') ? $res->[$i]->[0] : -1;
        }
    }

    return \@result;
}

1;
