package Yandex::Queryrec;

=head1 NAME

    Yandex::Queryrec - директовская обёртка вокруг аркадийной библиотеки YxQueryrec

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use YxQueryrec;

use Yandex::Trace;

use base qw/Exporter/;
our @EXPORT = qw/queryrec/;

=head2 $Yandex::Queryrec::DATA_PATH = '...'
    
    Путь к файлам со словарём и весами, если не определяется - используем файлы,
    установленные с YxQueryrec

=cut
our $DATA_PATH ||= '/var/www/direct-data/queryrec';

my $recognizer;

=head2 init()

    Инициалиация синглтона с распознователем языка.
    Необязательно вызывать в коде - он вызовется автоматически при первом обращении в queryrec

=cut
sub init() {
    my $profile = Yandex::Trace::new_profile('queryrec:init');
    $recognizer = YxQueryrec::CreateTQueryRecognizer("$DATA_PATH/queryrec.dict", "$DATA_PATH/queryrec.weights");
}

=head2 queryrec($text)

    Определение языка для переданного текста.
    Возвращает ссылку на хэш, где ключи - кодовые обозначения языков,
    а значения - вероятность языка.

=cut
sub queryrec($) {
    init() if !$recognizer;
    my $profile = Yandex::Trace::new_profile('queryrec:queryrec');
    return $recognizer->recognize(@_);
}

1;
