#!/usr/bin/perl -w

use strict;
use warnings;

use Test::Deep;
use Test::More tests => 3;

use Yandex::Redis::RateLimit; 

my $max_requests_number = $Yandex::Redis::RateLimit::MAX_REQUESTS;
my $client_id = 1;

my $redis = MockRedis->new(value => 1);

subtest 'if need create new key' => sub {
    my $rl = Yandex::Redis::RateLimit->new(redis => $redis, name => 'api5-reports-requests-number');
    is($rl->request_ok($client_id), 1);
    like($rl->redis->{key}, qr/^api5-reports-requests-number-$client_id-\d+/);
};

subtest 'if key exists' => sub {
    $redis->{value} = $max_requests_number - 1;
    my $rl = Yandex::Redis::RateLimit->new(redis => $redis, name => 'api5-reports-requests-number');
    is($rl->request_ok($client_id), 1);
};

subtest 'if max requests number exceeded' => sub {
    $redis->{value} = $max_requests_number;
    my $rl = Yandex::Redis::RateLimit->new(redis => $redis, name => 'api5-reports-requests-number');
    is($rl->request_ok($client_id), 0);
};


package MockRedis;

sub new {
    my $class = shift;
    my (%params) = @_;
    my $self = \%params;
    bless $self, $class;

    return $self;
}

sub incr {
    my ( $self, $key, $val ) = @_;
    $self->{key} = $key;
    $self->{value} ++;
    return $self->{value};
}

sub set {
    my ( $self, $key ) = @_;
    return 1;
}

1;



