package Yandex::ReportsXLSXWriter;

=head1 NAME

Yandex::ReportsXLSX - удобное создание экселевских таблиц в формате XLSX (MS Excel 2007+)

=head1 DESCRIPTION

=cut

use Direct::Modern;

use Excel::Writer::XLSX;

use base 'Yandex::ReportsXLSWriter';

sub _init_xls_workbook {
    my $self = shift;
    my $output = shift;
    my $xls = Excel::Writer::XLSX->new($output);
    $xls->set_optimization() unless $self->{no_optimization}; # optimization disable some functionality
    $self->{compatibility_mode} = 0; # compatibility_mode is deprecated in Excel::Writer::XLSX
    $self->{use_old_merge_method} = 0; # use_old_merge_method doesn't work with Excel::Writer::XLSX
    $self->{rewrite_merged_cells} = 1;
    return $xls;
}

{
my %normalized_format = (
    # format_name => { format_val_xls => format_val_xlsx }
    border => {1 => 7, 2 => 1,}, 
);
$normalized_format{top} = $normalized_format{left} = $normalized_format{right} = $normalized_format{bottom} = $normalized_format{border};  

sub normalize_format {
    
    my ($self, %format) = @_;
    foreach (keys %normalized_format) {
        next unless exists $format{$_} && exists $normalized_format{$_}->{$format{$_}};
        $format{$_} = $normalized_format{$_}->{$format{$_}};
    }
    return %format;
}
}

sub _prepare_and_write_formula 
{
    my ($self, $list, $row_num, $col_num, $xls_format, $formula, $value) = @_;
    # замеченные особенности:
    # если не указывать посчитанный результат формулы - $value, в OpenOffice при открытии в ячейках будут нули
    $list->write_formula($row_num, $col_num, $formula, $xls_format, $value);
}

1;