#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More tests => 10;
use Test::Deep;
use Test::Exception;

use Yandex::Retry;

use utf8;
use open ':std' => ':utf8';

for my $f (\&retry, \&relaxed) {
    cmp_deeply([$f->(sub {return (1,2)})], [1,2], "list context for list");
    cmp_deeply([scalar $f->(sub {return (1,2)})], [2], "scalar context for list");
    cmp_deeply([scalar $f->(sub {return 3})], [3], "scalar context for scalar");
    cmp_deeply([$f->(sub {return 3})], [3], "list context for scalar");
    dies_ok(sub {$f->(sub {die;})}, "dies");
}
