#!/usr/bin/perl -w

=pod
    $Id$
=cut

use strict;
use Test::More tests => 5;
use Test::Exception;
use Time::HiRes;

use Yandex::Retry;

use utf8;
use open ':std' => ':utf8';

sub t {
    my ($times, $sleep, $expected) = @_;
    my $t1 = Time::HiRes::time();
    if (defined $times) {
        relaxed times => $times, sub {Time::HiRes::sleep($sleep)};
    } else {
        relaxed sub {Time::HiRes::sleep($sleep)};
    }
    my $interval = Time::HiRes::time() - $t1;
    ok($expected - 0.1 <= $interval &&  $interval <= $expected + 0.1, "real: $interval, expected: $expected");
}

t(undef, 0.2, 0.4);
t(undef, 0.5, 1);
t(2, 0.2, 0.6);
t(2, 0.5, 1.5);
t(10, 0.1, 1.1);
