#!/usr/bin/perl -w
use strict;
use Test::More tests => 1;
use Test::Exception;
use Time::HiRes;
use Yandex::Retry;

use utf8;
use open ':std' => ':utf8';

sub t {
    my ($times, $sleep, $expected) = @_;
    my $t1 = Time::HiRes::time();
    my $sub = sub {
        my $guard = relaxed_guard times => $times;
        Time::HiRes::sleep($sleep);
        return $_[0]
    };
    my $res = $sub->(10);
    my $interval = Time::HiRes::time() - $t1;
    ok($expected - 0.1 <= $interval &&  $interval <= $expected + 0.1, "real: $interval, expected: $expected");
}

t(2, 0.2, 0.6);
