#!/usr/bin/perl -w

=pod
    $Id$
=cut

use strict;
use Test::More;
use Test::Exception;

use Yandex::Retry;

use utf8;
use open ':std' => ':utf8';

# параметры retries для тестирования вечно-успешной функции
my @a_1 = (2 .. 5, 17);
# на который раз успешно исполнится переменно-успешная функция
my $N_1 = 4;
# параметры retries для тестирования вечно-провальной функции
my @a_2 = (2 .. 6, 18);

Test::More::plan(tests => 2 * @a_1 + 2 * ($N_1 + 1) + 2 * @a_2 );

# TODO Хорошо бы еще тестировать умолчальное число повторов, но для этого лучше бы получать его переменной из модуля.
# еще есть параметр pauses, с ним вообще неясно

# функция всегда отрабатывает успешно -- на первой итерации все и заканчивается
for my $i (@a_1) {
    my $try_count = 0;
    lives_ok { 
        retry tries => $i, sub {
            $try_count++;
            return 1;
        }
    };
    is($try_count, 1, "good sub, $i retries - unexpected number of tries"); 
}

# функция отрабатывает нормально только на $N_1-й раз 
# меньше $N_1 попыток -- die...
for my $i (1 .. $N_1 - 1){
    my $try_count = 0;
    dies_ok { 
        retry tries => $i, sub {
            $try_count++;
            die unless $try_count == $N_1;
        }
    } $N_1."-good sub, $i retries -- expected to die";
    is($try_count, $i, $N_1."-good sub, $i retries - unexpected number of tries"); 
}
# ... $N_1 и больше попыток -- ok
for my $i ($N_1 .. $N_1 + 1){
    my $try_count = 0;
    lives_ok { 
        retry tries => $i, sub {
            $try_count++;
            die unless $try_count == $N_1;
        }
    } $N_1."-good sub, $i retries -- expected to live";
    is($try_count, $N_1, $N_1."-good sub, $i retries - unexpected number of tries"); 
}

# функция всегда умирает
# любое количество попыток -- die
for my $i (@a_2){
    my $try_count = 0;
    dies_ok { 
        retry tries => $i, sub {
            $try_count++;
            die;
        }
    } "bad sub, $i retries -- expected to die";
    is ($try_count, $i, "bad sub, $i retries - unexpected number of tries"); 
}

