package Yandex::Runtime;

=head1 NAME
    
    Yandex::Runtime
    $Id$
    Функции для управления выполнением perl - кода

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use Carp qw/croak/;

use base qw/Exporter/;
our @EXPORT = qw/
        need_list_context
        need_scalar_context
        need_void_context
                /;

=pod

Умереть если вызывающая фунцкция вызвана в скалярном контексте

####### somewhere in Common

sub validate_my_private_lovely_stuff {
    need_list_context();
    
    my @reasons = ();
    push @reasons, iget("Вам очень не повезло! Такое бывает в 10% случаев. Попробуйте повторить операцию ещё раз.") if rand() > 0.95;
    return @reasons;
}

####### somewhere in DoCmd

sub saveupdatedmyPrivateLovelyStuff {
    ...
    my $stuff = get_users_stuff($FORM);
    my $err = validate_my_private_lovely_stuff();   # <--- Die here!
    ...
}

=cut

sub need_list_context() {
    my @c = caller(1);
    croak("$c[3] in $c[1]:$c[2]  must be called in list context") unless $c[5];
}

=pod

Способ сказать: "Я возвращаю скаляр!"

Умирать если функция вызвана не в скалярном контексте.

sub get_phrases_hash {
    need_scalar_context;
    
    my $hash;
    ...

    return $hash;
}

sub cmd_checkPhrases {
    ...
    my @phrases = get_phrases_hash();   # <-- Die
    ...
}

=cut

sub need_scalar_context() {
    my @c = caller(1);
    croak("$c[3] in $c[1]:$c[2]  must be called in scalar context") unless !$c[5] && defined $c[5];
}

=pod

Способ сказать: "не возвращаю я ничего"

Умирать если функция вызвана не в void-ном контексте.

=cut

sub need_void_context() {
    my @c = caller(1);
    croak("$c[3] in $c[1]:$c[2] must be called in void context") unless !defined $c[5];
}

1;


