#!/usr/bin/env perl

use Direct::Modern;
use open ':std', ':encoding(UTF-8)';

use Test::More;
use Test::Exception;

our $SHARDS_NUM = 10;
$Yandex::ScriptDistributor::SHARDS_NUM_REF = \$SHARDS_NUM;
use Yandex::ScriptDistributor qw/get_distribution/;

my %distribution;
my $num = 26;
%Yandex::ScriptDistributor::CONF = (
    test1 => {
        distribution => {
            shard_1 => {
                '_' => 6
            },
            shard_2 => {
                '_' => 3
            },
            shard_3 => {
                '_' => 3
            },
            shard_4 => {
                '_' => 3
            },
            shard_5 => {
                '_' => 2
            },
            shard_6 => {
                '_' => 2
            },
            shard_7 => {
                '_' => 3
            },
            shard_8 => {
                '_' => 2
            },
            shard_default => {
                '_' => 1
            }
        }
    },
    DEFAULT => {
        distribution => {
            shard_1 => {
                '_' => 4
            },
            shard_default => {
                '_' => 1
            }
        }
    },
    test3 => {
        distribution => {
            shard_1 => {
                heavy => 2,
                easy => 2,
                heavy2 => 1
            },
            shard_3 => {
                heavy => 2,
                easy => 2,
                heavy2 => 6
            },
            shard_default => {
                heavy => 1,
                easy => 1,
                heavy2 => 5
            }
        }
    }
);

%distribution = %{get_distribution('test1', $num)};
is(scalar keys %distribution, $SHARDS_NUM, 'custom script, shard coverage');
dies_ok(sub {get_distribution('test1', $num + 1)}, 'custom script, extra run count');

$num = 13;
%distribution = %{get_distribution('test2', $num)};
is(scalar keys %distribution, $SHARDS_NUM, 'custom default script, shard coverage');
dies_ok(sub {get_distribution('test2', $num + 1)}, 'custom default script, extra run count');

$num = 71;
%distribution = %{get_distribution('test3', $num)};
is(scalar keys %distribution, $SHARDS_NUM, 'custom script with run_types, shard coverage');
ok(scalar @{$distribution{1}->{heavy2}} == 1
    && scalar @{$distribution{5}->{heavy2}} == 5
    && scalar @{$distribution{$SHARDS_NUM}->{heavy}} == 1,
    'custom script with run_types, values'
);

done_testing;
