#!/usr/bin/env perl

use Direct::Modern;
use open ':std', ':encoding(UTF-8)';

use Test::More;

our $SHARDS_NUM = 10;
$Yandex::ScriptDistributor::SHARDS_NUM_REF = \$SHARDS_NUM;
use Yandex::ScriptDistributor qw/juggler_vars/;
use List::AllUtils qw/none/;

%Yandex::ScriptDistributor::CONF = (
    test1 => {
        distribution => {
            shard_1 => {
                heavy => 2,
                easy => 2
            },
            shard_3 => {
                heavy => 2,
                easy => 2
            },
            shard_default => {
                heavy => 1,
                easy => 1
            },
        },
        properties => {
            run_type => {
                heavy => {
                    juggler_ttl => '1h'
                },
            }
        }
    },
    DEFAULT => {
        distribution => {
            shard_1 => {
                '_' => 4
            },
            shard_2 => {
                '_' => 2
            },
            shard_3 => {
                '_' => 2
            },
            shard_4 => {
                '_' => 2
            },
            shard_default => {
                '_' => 1
            }
        }
    }
);

my $JV = juggler_vars('test1');
is(scalar keys %$JV, 24, 'custom script, number of entries');
ok((! exists $JV->{1}->{ttl}), 'custom script, check first entry ttl');
ok((exists $JV->{24}->{ttl} && $JV->{24}->{ttl} eq '1h'), 'custom script, check last entry ttl');

$JV = juggler_vars('test2');
is(scalar keys %$JV, 16, 'default script, number of entries');
ok((none {exists $JV->{$_}->{ttl}} keys %$JV), 'default script, check for no ttl');

done_testing;
