# $Id$

=head1 NAME

    Yandex::SendMail

=head1 DESCRIPTION

    Отсылка писем (через sendmail)

    Внимание! Модуль новый, интерфейс еще не совсем окончательный. 
    Возможны изменения в именах переменных/функций/типе и порядке параметров. 
    EXP 15.04.2010

=head1 FUNCTIONS


=cut

package Yandex::SendMail;
use warnings;
use strict;
use Encode;

use Cwd;
use Fcntl ':flock';
use MIME::Base64 qw(encode_base64);
use Digest::MD5 qw(md5_hex);
require Email::Date::Format;
use Data::Dumper;
use POSIX qw(strftime);
use Yandex::HashUtils;
use Yandex::IDN;

use utf8;

require Exporter;

our $VERSION = '0.01';
our @ISA = qw(Exporter);
our @EXPORT = qw(
    send_alert
);

our @EXPORT_OK = qw (
    sendmail
    create_letter
    call_sendmail
    extract_email
    extract_headers
    yservice_headers
);

# адресат для отправки уведомлений о проблемах доставки определяется отдельно
our $ENVELOPE_SENDER ||= 'devnull@yandex.ru';

# программа для отправки писем, к ней дописывается -f$ENVELOPE_SENDER, если определён
our $MAIL_PROG ||= '/usr/sbin/sendmail -oi -t';

# соль/имя сервиса для подписи заголовка X-YService
our $YSERVICE_SALT;
our $YSERVICE_NAME;

# ссылка на функцию для логгирования писем
# если установлена -- будет вызываться из sendmail с именованными параметрами: 
# $logmail_sub->( to => $to, tt_name => $tt_name, subj => $subj_orig, letter => $letter, client_id => $client_id ); 
our $logmail_sub;

# настройки для send_alert:
# From
our $FROM_FIELDS_FOR_ALERTS;
# To
our $MAIL_FOR_ALERTS;
# дефолтный subject
our $SUBJ_FOR_ALERTS;

# настройка "перенаправлять все письма в файл/на тестовый адрес" (для тестирования, например)
# $FAKEMAIL = "file:$LOG_ROOT/fakemail.log"; # файл
# $FAKEMAIL = 'mailto:name@company.com';     # тестовый адрес
our $FAKEMAIL;


# Лог для контролируемой рассылки алертов
our $SEND_ALERT_LOG;

=item LOG_UMASK

    Значение umask для создания новых файлов.

=cut

our $LOG_UMASK;

# по email возвращаем (to, cc, bcc, reply_to)
sub extract_email {
    my $email = shift;

    my ($to, $cc, $bcc, $reply_to);

    if (ref($email) eq "HASH") {
        ($to, $cc, $bcc, $reply_to) = ($email->{to}, $email->{cc} || '', $email->{bcc} || '', $email->{reply_to} || '');
    } else {
        ($to, $cc, $bcc, $reply_to) = ($email, '', '', '');
    }

    return ( punify_email($to), punify_email($cc), punify_email($bcc), punify_email($reply_to));
}

# кодирует русские емейлы в punycode
sub punify_email {
    my $email = shift;
    return $email unless ($email);

    my ($login, $domain) = split('@', $email, 2);
    $domain = Yandex::IDN::idn_to_ascii($domain);

    return $login.'@'.$domain;
}


# по email(параметр, передающийся в sendmail) заголовки (все, кроме to/cc/bcc/reply_to)
sub extract_headers {
    my $email = shift;
    if (ref($email) eq "HASH") {
        return map {$_ => $email->{$_}} grep {!/^(to|cc|bcc|reply_to)$/i} keys %$email;
    } else {
        return ();
    }
}



# Вычислить заголовки, которые нужно добавить к письму для поддержки X-YService
sub yservice_headers {
    my ($mail) = @_;
    return {} unless $YSERVICE_NAME && $YSERVICE_SALT;
    # Если отправляем письмо на наш сервис - добавляем заголовок X-YService
    my $to = $mail->{To} =~ /<(.*)>/ ? $1 : $mail->{To};
    if (!$mail->{CC} && !$mail->{BCC} && $to =~ /\@(ya\.ru|yandex\.ru|yandex\.com|narod\.ru|yandex\.ua)$/) {
        my $date = $mail->{Date} || Email::Date::Format::email_date();
        my $salted_string = join('_', $date, $mail->{From}, $mail->{PlainSubject}, $YSERVICE_NAME, $YSERVICE_SALT);
        my $sign = encode_base64($YSERVICE_NAME.' '.md5_hex( Encode::encode('utf8', $salted_string) ), '');
        return {'Date' => Encode::encode_utf8($date), 'X-Yandex-Service' => Encode::encode_utf8($sign)};
    }
    return {};
}



# Разбиваем строку по пробелам на небольшие кусочки
# mime-им их и возвращаем строку пригодную для указывания в заголовке,
# чтобы было так:
# Subject: =?utf-8?B?faijdspfoijasfdpoijaspf?=
#         =?utf-8?B?faspf?=
sub mime_encode {
    my $text = shift;
    # бъём строку на части по пробелам
    my @parts = $text =~ /(.{1,30}.*?(?:\s|$))/g;
    return join "\n\t", map {'=?utf-8?B?'.encode_base64(Encode::encode('utf-8',$_), '').'?='} @parts;
}



=head1 call_sendmail

    call_sendmail($letter_source);

=cut

sub call_sendmail {
    my $letter = shift;
    my $program = "|$MAIL_PROG".($ENVELOPE_SENDER ? " -f$ENVELOPE_SENDER" : '');
    my $header = "";
    if ($FAKEMAIL) {
        my $fakemail = $FAKEMAIL;
        if (ref($fakemail) eq 'HASH') {
            my ($parsed_mail) = $letter =~ /^To:\s+(\S+)/m;
            $fakemail = $FAKEMAIL->{$parsed_mail || 'default'} || $FAKEMAIL->{'default'};
        }
        if ($fakemail =~ /^file:\s*(.*)/) {
            $program = ">>$1";
            $header = "\n\n".("=" x 10)." ".strftime("%Y-%m-%d %H:%M:%S", localtime)." ==\n\n";
        } elsif ($fakemail =~ /^mailto:\s*(.*)/) {
            my $mail = $1;
            # меняем заголовки, но письмо отправим как обычно!
            $letter =~ s/^(To|CC|BCC):\s*(.*)/$1: $mail\nX-$1: $2/gmi;
            $letter = "X-Path: ".Cwd::realpath($INC{'Yandex/SendMail.pm'})."\n".$letter;
        } else {
            die "Incorrect FAKEMAIL: '$fakemail'";
        }
    }

    $letter =~ s/(?<!\r)\n/\r\n/g; # use CR LF

    # переводим письмо в бинарную форму
    if (Encode::is_utf8($letter)) {
        $letter = Encode::encode_utf8($letter);
    }
    # отправляем письмо
    open(my $mail_fh, $program) or die "Can't open '$program': $!";
    if ($header) {
        print($mail_fh $header) || die "Can't send mail: $!";
    }
    print($mail_fh $letter) || die "Can't send mail: $!";
    close($mail_fh) || die "Sendmail close failed: $!";
}



=head1 send_alert

send mail alert

=cut

sub send_alert
{
    my ($content, $subject, $email, $umask) = @_;

    local $logmail_sub = undef;
    $subject = $SUBJ_FOR_ALERTS unless defined $subject;
    if( defined $email ) {
        sendmail($email, $FROM_FIELDS_FOR_ALERTS, $subject, \$content, 'text');
    } else {
        $email = $MAIL_FOR_ALERTS;
        sendmail_tofile($email, $FROM_FIELDS_FOR_ALERTS, $subject, \$content, 'text', $umask);
    }
}


=head1 sendmail

send mail across sendmail

 sendmail($email, $from, $subj, $content, $content_type);
   $email        - field 'To:' or ref_to_hash: {to => 'a@b.com', cc => 'a@b.com', bcc => 'a@b.com', 'X-Additional-Header1' => 'val1', ...}
   $content_type - 'text' or 'html'

=cut

# TODO перенести также и sendmail_attach ?
# используется ли где-нибудь $not_logging_flag ?
sub sendmail
{
    my ($email, $from, $subj, $content, $content_type, $not_logging_flag, $tt_name, $client_id) = @_;
    my $subj_orig = $subj;

    # собираем само письмо
    my ($letter, $to) = create_letter($email, $from, $subj, $content, $content_type);
    return undef unless $letter;

    local $@;
    eval {
        call_sendmail($letter);
    };
    # or die?
    warn $@ if $@;

    # logging
    # Убрать проверку про 'ppc-admin@yandex-team.ru' ?
    if ($to ne 'ppc-admin@yandex-team.ru' && !$not_logging_flag && $logmail_sub) { 
        $logmail_sub->( to => $to, tt_name => $tt_name, subj => $subj_orig, letter => $letter, client_id => $client_id );
    }
}

=head2 create_letter($email, $from, $subj, $content, $content_type) 

    Создаёт строку, содержащее полное письмо со всеми заголовками
    Параметры аналогичны sendmail
    В скалярном контексте возвращает строку с письмом,
    в списковом - строку с письмом и адрес To

=cut
sub create_letter {
    my ($email, $from, $subj, $content, $content_type) = @_;
    my $subj_orig = $subj;

    return undef unless($$content);

    my ($to, $cc, $bcc, $reply_to) = extract_email($email);

    my $cfrom = '';
    if (ref($from) eq "HASH") {
        my $name = $from->{name}?'=?utf-8?B?'.encode_base64(Encode::encode('utf-8', $from->{name} ), '').'?=':'';
        $cfrom = $name."<".$from->{email}.">";
    } else {
        $cfrom  = $from;
    }

    # ! sec. danger
    # return esli kto-to nas hochet haknutx ..
    my @bad_emails = grep { !Yandex::IDN::is_valid_email($_) } $to||'no To field', split(/\s*,\s*/, $cc), split(/\s*,\s*/, $bcc);
    if (@bad_emails) {
        print STDERR "Bad email address?: ".join(", ", @bad_emails)."\n";
        return;
    }

    $content_type = (defined $content_type && $content_type eq 'html') ? 'text/html' : 'text/plain';

    # Создаём заголовки письма
    my %mail_headers = (
        'Precedence' => 'bulk',
        'Subject' => mime_encode($subj),
        'From' => $cfrom,
        'To' => $to,
        'Content-Type' => "$content_type; charset=\"utf-8\"",
        'Content-Transfer-Encoding' => '8bit',
        'Mime-Version' => '1.0',
        extract_headers($email),
        );
    $mail_headers{CC} = $cc if $cc;
    $mail_headers{BCC} = $bcc if $bcc;
    $mail_headers{'Reply-To'} = $reply_to if $reply_to;

    # Добавляем заголовки, нужные для поддержки X-YService
    hash_merge \%mail_headers, yservice_headers({%mail_headers, PlainSubject => $subj_orig});

    # собираем само письмо
    my $letter = join("", map {"$_: $mail_headers{$_}\n"} keys %mail_headers)
        ."\n"
        .$$content
        ;
    return wantarray ? ($letter, $to) : $letter;
}


sub sendmail_tofile
{
    my ($email, $from, $subj, $content, $content_type, $umask) = @_;
    return unless $$content;

    my $old_umask;
    $umask = defined $umask ? $umask : $LOG_UMASK;

    if ( defined $umask ) {
        $old_umask = umask( $umask );
        die "Umask error: $!" if ! defined $old_umask;
    }

    open(my $log_fh, ">>:encoding(utf8)", $SEND_ALERT_LOG) or warn("Can't open lockfile: $SEND_ALERT_LOG");

    if ( ! flock( $log_fh, LOCK_EX ) ) {
        sendmail($email, '"Yandex.PPC" <ppc@yandex-team.ru>', $subj, $content, 'text');
    } else {
        print $log_fh qq!\n\#subject=$subj\n#body=!.$$content.qq!\n!;
        flock($log_fh, LOCK_UN) or die "Can't unlock $SEND_ALERT_LOG: $!";
    }

    close($log_fh) or die "Can't close $SEND_ALERT_LOG: $!";

    if ( defined $old_umask ) {
        die "Umask error: $!" if ! defined umask( $old_umask );
    }
}

1;


=head1 AUTHORS

=cut
