#!/usr/bin/perl -w

use utf8;
use strict;
use warnings;

use Test::More tests => 12;
use Data::Dumper;

use constant TEST_SIZE => 500;

use constant {
    WORD_CORRECT    => 'корова',
    WORD_INCORRECT  => 'карова',
};

use Yandex::Speller;

$Yandex::Speller::SPELLER_TIMEOUT = 120;

my $speller = Yandex::Speller->new(); # test_server => 1 работать не будет, проверяем на проде
my $params = { group => 1, safety => 1, skiplist => { 'yandex' => 1, 'Yandex' => 1 } };

# старый интерфейс (одно значение)
my ($res_incorrect, $res_correct) = (
        $speller->check(WORD_INCORRECT, $params),
        $speller->check(WORD_CORRECT, $params),
    );
is( defined $res_incorrect, 1, 'Incorrect scalar error exists' );
is( exists $res_incorrect->{error}, 1, 'Incorrect scalar error exists' );
is( @{ $res_incorrect->{error} }, 1, 'Incorrect scalar' );
is( $res_correct, undef, 'Correct scalar' );

my $result = $speller->check([ WORD_INCORRECT, WORD_CORRECT ], $params);
my $expected_error = {
                        'error' => [
                                                 {
                                                     'len' => '6',
                                                     'word' => WORD_INCORRECT,
                                                     'col' => '0',
                                                     'row' => '0',
                                                     'pos' => '0',
                                                     's' => [
                                                                WORD_CORRECT
                                                            ],
                                                     'code' => '1'
                                                 }
                                             ]
                    };
is_deeply( $result, [ $expected_error, undef ], 'Bulk test #1' );

$result = $speller->check([ WORD_CORRECT, WORD_INCORRECT ], $params);
is_deeply( $result, [ undef, $expected_error ], 'Bulk test #2' );

# bulk test
my (@bulk_input, @bulk_output);
for (1..TEST_SIZE) {
    push @bulk_input, WORD_CORRECT;
    push @bulk_output, undef;
    push @bulk_input, WORD_INCORRECT;
    push @bulk_output, $expected_error;
}
is_deeply( $speller->check(\@bulk_input, $params), \@bulk_output, 'Bulk test #3');

{
    local $Yandex::Speller::SPELLER_URL = "http://asdf.ru"; # not working url, test should work as we don't go to the service itself for empty requests
    my $broken_speller = Yandex::Speller->new(test_server => 1);
    is_deeply( $broken_speller->check(undef, $params), undef, 'undef is undef');
    is_deeply( $broken_speller->check("", $params), undef, 'empty string is undef');
    is_deeply( $broken_speller->check(["", "", ""], $params), [undef, undef, undef], 'array of empty strings is array of undefs');
    is_deeply( $broken_speller->check([undef, undef], $params), [undef, undef], 'array of undef is array of undef');
    is_deeply( $broken_speller->check(["", undef], $params), [undef, undef], 'array of undef and empty string is array of undef');
}
