package Yandex::Staff;

# $Id$

=head1 NAME
    
    Yandex::Staff
    Perl обертка для API http://center.yandex-team.ru/api/v1/

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use Yandex::HTTP;
use JSON::Syck;

use URI::Escape qw/uri_escape_utf8/;

use Data::Dumper;

use base qw/Exporter/;
our @EXPORT = qw/
    is_domain_login_exists
    get_staff_info
/;
    
# токен для доступа к api:
# http://center.yandex-team.ru/api/v1
# http://wiki.yandex-team.ru/intranet/center/API

our $STAFF_API_TOKEN ||= 'fb8d6296b3175d5e62dc9c639c0b3e116d795015';
our $STAFF_API_URL ||= 'http://center-robot.yandex-team.ru/api/v1/';

#-----------------------------------------------------------

=head2 is_domain_login_exists($domain_login)
    
    Проверяет, существует ли данный логин на staff.yandex-team.ru

=cut

sub is_domain_login_exists {

    my $domain_login = shift;

    my $info = get_staff_info($domain_login);

    if (ref($info) eq 'HASH' && %$info) {
        return 1;
    } else {
        return 0;
    }
}

#-----------------------------------------------------------

=head2 get_staff_info($domain_login, \@fields)
    
    получаем ФИО, email, phone по доменному логину со стаффа

    my $staff = get_staff_info($domain_login)
    my ($FIO, $email, $phone) = ($staff->{first_name} . $staff->{last_name}, $staff->{work_email}, $staff->{work_phone});

=cut

sub get_staff_info
{
    my $domain_login = shift;
    my $fields = shift || [qw/id login first_name last_name work_email work_phone position/];

    my $url = Yandex::HTTP::make_url($STAFF_API_URL.'user/'.uri_escape_utf8($domain_login).'.json',
        {
            token => $STAFF_API_TOKEN,
            fields => join('|', @$fields),
        }
    );
    my $ua_response = http_get($url, timeout => 5);

    if ($ua_response && $ua_response =~ m/^\{.*\}$/) {
        local $JSON::Syck::ImplicitUnicode = 1;
        my $staff = JSON::Syck::Load($ua_response);
        for my $k (keys %$staff) {
            # convert "\u0421\u0435\u0440\u0433\u0435\u0439" to utf8
            $staff->{$k} =~ s/\\u([0-9a-f]{4})/chr(hex($1))/gie;
        }
        return $staff;
    } else {
        die "Staff API Error: \n Incorrect output, JSON expected";
    }
}

1;
