#!/usr/bin/perl

package main;

use strict;
use warnings;
use utf8;

use Test::More;
use Yandex::Staff3 qw( get_mass_staff_info );

# сделаем имитацию загрузки Settings.pm
$Yandex::Staff3::STAFF_OAUTH_TOKEN = '1';
$Yandex::Staff3::STAFF_OAUTH_URL   = 'https://staff-api.yandex-team.ru/v3/';

# сделаем имитацию работы сети, что бы реальные запросы на Staff не отправлялись, 
# но при этом возвращался не отличимый от реального ответ
use Aspect;

around {
    my $rnd_int = int(rand(45)) + 5;
    my $return_value = '';

    for my $curr_int ( 1..$rnd_int ) {
        $return_value .= ', ' if $return_value;
        $return_value .= '{"work_phone": '.int(rand(6000) + 1000).', "login": "meridian'.$curr_int.'"}';
    }

    $return_value = '{"links": {}, "page": 1, "limit": 50, "result": ['.$return_value.'], "total": '.$rnd_int.', "pages": 1}';
    $_->return_value( $return_value );
} call 'Yandex::HTTP::http_fetch';



my $phones_by_logins = phones_by_logins('volozh', 'meridian', 'oxid', 'trojn', 'gennadiy');
ok($phones_by_logins && (ref($phones_by_logins) eq 'ARRAY') && scalar(@$phones_by_logins), 'Phones of logins');
# print "\$phones_by_logins = ".join(', ', @$phones_by_logins)."\n";

=head2 phones_by_logins( \@domain_logins )

    Узнает телефоны по переданным логинам и вернёт их, если такой логин существует на staff.yandex-team.ru, 
    а так же обладает рабочим телефоном. Пример использования: 

    use Yandex::Staff3 qw(get_mass_staff_info);
    my $phones_by_logins = phones_by_logins('meridian', 'oxid', 'trojn', 'gennadiy');

=cut

sub phones_by_logins {
    my @domain_logins = @_;

    my $info = get_mass_staff_info(\@domain_logins, ['login', 'work_phone']);

    if ( $info && (ref($info) eq 'HASH') && scalar(keys %$info) ) {
        my @work_phone = ();
        
        for my $login ( keys %$info ) {
            if ( $info->{$login}->{'work_phone'} ) {
                push @work_phone, "'".$login."' => '".$info->{$login}->{'work_phone'}."'";
            }
        }

        return \@work_phone; # всё ОК, такой юзер нашелся и телефон у него тоже есть
    }
    elsif ( $info && (ref($info) eq 'HASH') ) {
        return []; # такие логины НЕ известны Стаффу
    }
    else {
        diag("Error into result structure or system promlems into API!");
        return undef; # API сломался, в общем системная проблема, надо разбираться
    }
}

done_testing();
