#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;

use Yandex::StopWords;
use Yandex::Test::UTF8Builder;

my @tests = (
    #[$in, $expected],
    ['окно' => 0],
    ['своё' => 1],
    ['свое' => 1],
);

Test::More::plan(tests => scalar @tests);

for my $test (@tests) {
    my ($in, $expected) = @$test;
    my $expected_ret = ($expected) ? 1 : '';
    is(Yandex::StopWords::is_stopword($in), $expected_ret, "is_stopword($in) = $expected");
}
