#!/usr/bin/perl -w

=pod
    $Id$
=cut

use strict;
use warnings;
use Test::More;

use Yandex::StopWords;
*pqp = \&Yandex::StopWords::process_quoted_phrases;

use utf8;
use open ':std' => ':utf8';

is(pqp('Москву'), 'Москву', "simple");
is(pqp('Москву -qwe'), 'Москву -qwe', "simple minus");
is(pqp('Москву -!qwe -asdf'), 'Москву -!qwe -asdf', "simple excl minus");

is(pqp('"Москву"'), 'Москву ~0', "simple quotes");
is(pqp('"Санкт-Петербург"'), 'Санкт-Петербург ~0', "quotes defis");
is(pqp('"хочу в Москву"'), 'хочу +в Москву ~0', "quotes with stop");
is(pqp('"хочу !в Москву"'), 'хочу !в Москву ~0', "quotes with exc-stop");

is(pqp('хочу в +Москву'), 'хочу в +Москву', "simple plus");
is(pqp('хочу +в Москву'), 'хочу +в Москву', "simple plus-stop");
is(pqp('"хочу в +Москву"'), 'хочу +в +Москву ~0', "quotes with stop and plus");
is(pqp('"хочу +в Москву"'), 'хочу +в Москву ~0', "quotes with plus-stop");

is(pqp(q!"м'який"!), q!м'який ~0!, "quotes with apos");

is(pqp(q{"+хочу !в +Москву"}), q{+хочу !в +Москву ~0}, "quotes with quotes and specific symbols");

is(pqp(q!"скажи мне"!), q!скажи +мне ~0!, "quotes with quotes");
is(pqp(q!"скажи +мне"!), q!скажи +мне ~0!, "quotes with quotes and plus");
is(pqp(q{"скажи !мне"}), q{скажи !мне ~0}, "quotes with quotes and specific symbol");

{
    my $warned = 0;
    local $SIG{__WARN__} = sub {$warned++;};
    is(pqp(q{"me 6p smeg  "}), q{me 6p smeg ~0}, "word 'me' in quotes");
    is($warned, 0, "no warnings, when word 'me' in quotes appears");
}

is(pqp('0'), '0', 'zero');

done_testing;
