#!/usr/bin/perl -w

=pod
    $Id: process_quoted_phrases.t 4970 2014-11-11 14:03:43Z zhur $
=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use Test::More;
use Test::Exception;
use Path::Tiny;

use Yandex::StopWords qw/is_stopword $STOP_WORDS_FILE $STOP_WORDS_AUTOREFRESH_FILE/;

my $tmpdir = Path::Tiny->tempdir("yandex-stopwords-test-XXXXXX");

$STOP_WORDS_FILE = path('stopwords.lst')->absolute($tmpdir);
$STOP_WORDS_AUTOREFRESH_FILE = path('stopwords_autorefresh.lst')->absolute($tmpdir);
$Yandex::StopWords::STOP_WORDS_CHECK_FILE_MODIFIED_SECONDS = 0;

dies_ok { is_stopword('apple') } 'words file not exists';

add_word($STOP_WORDS_FILE, 'apple');
is(is_stopword('apple'), 1, 'step 1, default words file created');

sleep(1);
add_word($STOP_WORDS_FILE, 'table');
is(is_stopword('table'), 1, 'step 2, default words file modified');

sleep(1);
add_word($STOP_WORDS_AUTOREFRESH_FILE, 'london');
is(is_stopword('london'), 1, 'step 3, autorefresh words file created');

$Yandex::StopWords::STOP_WORDS_CHECK_FILE_MODIFIED_SECONDS = 2;
sleep(1);
add_word($STOP_WORDS_AUTOREFRESH_FILE, 'capital');
is(is_stopword('capital'), '', 'step 4, autorefresh words file modified, STOP_WORDS_CHECK_FILE_MODIFIED_SECONDS=2');
sleep(2);
is(is_stopword('capital'), 1, 'step 5, autorefresh words file was not reloaded yet, STOP_WORDS_CHECK_FILE_MODIFIED_SECONDS=2, sleep=2');

sub add_word {
	my ($filepath, $word) = @_;

	path($filepath)->append_utf8("\n$word");
}
done_testing;
