#!/usr/bin/perl
use strict;
use warnings;

# $Id$

use File::Temp;
use Test::Deep;
use Test::More tests => 6;

use Yandex::Svn;

my $tmpdir  = File::Temp->newdir;
my $repodir = "$tmpdir/repo";
my $wcdir   = "$tmpdir/wc";

my $extrepodir = "$tmpdir/repo-external";
my $extwcdir   = "$tmpdir/wc-external";

my $opt_quiet = '-q';

my @commands = (
    "svnadmin create $extrepodir",
    "svn checkout $opt_quiet file://$extrepodir $extwcdir",
    "touch $extwcdir/extfile",
    "svn add $opt_quiet $extwcdir/extfile",
    "svn commit $opt_quiet -m \"commit\" $extwcdir",

    "svnadmin create $repodir",
    "svn checkout $opt_quiet file://$repodir $wcdir",

    "svn propset $opt_quiet svn:externals \"external file://$extrepodir\" $wcdir",
    "svn commit $opt_quiet -m \"commit svn:external\" $wcdir",
    "svn update $opt_quiet $wcdir",

    "touch $wcdir/ignored",
    "svn propset $opt_quiet svn:ignore ignored $wcdir",
    "svn commit $opt_quiet -m \"commit svn:ignore\" $wcdir",

    "touch $wcdir/normal $wcdir/modified",
    "svn add $opt_quiet $wcdir/normal $wcdir/modified",
    "svn commit $opt_quiet -m \"commit a normal and a modified file\" $wcdir",

    "mkdir $wcdir/subdir",
    "touch $wcdir/subdir/normal",
    "svn add $opt_quiet $wcdir/subdir",
    "svn commit $opt_quiet -m \"commit a subdirectory\" $wcdir",

    "touch $wcdir/unversioned $wcdir/subdir/unversioned",
    "echo \"content\" >> $wcdir/modified",
);

system $_ foreach @commands;

is_deeply(
    svn_file_status($wcdir),
    {
        external    => [ "$wcdir/external" ],
        ignored     => [ "$wcdir/ignored" ],
        modified    => [ "$wcdir/modified" ],
        normal      => [ $wcdir, "$wcdir/normal", "$wcdir/subdir", "$wcdir/subdir/normal" ],
        unversioned => [ "$wcdir/subdir/unversioned", "$wcdir/unversioned" ],
    },
    'svn_file_status',
);

is_deeply(
    svn_file_status( $wcdir, depth => 'files' ),
    {
        ignored     => [ "$wcdir/ignored" ],
        modified    => [ "$wcdir/modified" ],
        normal      => [ $wcdir, "$wcdir/normal" ],
        unversioned => [ "$wcdir/unversioned" ],
    },
    'svn_file_status(depth => files)',
);

is_deeply(
    svn_file_status( $wcdir, externals => 1 ),
    {
        external    => [ "$wcdir/external" ],
        ignored     => [ "$wcdir/ignored" ],
        modified    => [ "$wcdir/modified" ],
        normal      => [
            $wcdir,
            "$wcdir/normal",
            "$wcdir/subdir",
            "$wcdir/subdir/normal",
            "$wcdir/external",
            "$wcdir/external/extfile",
        ],
        unversioned => [ "$wcdir/subdir/unversioned", "$wcdir/unversioned" ],
    },
    'svn_file_status(externals => 1)',
);

is_deeply(
    [ svn_files($wcdir) ],
    [ $wcdir, "$wcdir/modified", "$wcdir/normal", "$wcdir/subdir", "$wcdir/subdir/normal" ],
    'svn_files',
);

is_deeply(
    [ svn_unversioned_files($wcdir) ],
    [ "$wcdir/subdir/unversioned", "$wcdir/unversioned" ],
    'svn_unversioned_files',
);

is_deeply(
    [ svn_unversioned_files( $wcdir, include_ignored => 1 ) ],
    [ "$wcdir/subdir/unversioned", "$wcdir/unversioned", "$wcdir/ignored" ],
    'svn_unversioned_files(include_ignored => 1)',
);
