package Yandex::Flasm;

=pod
    $Id$
    Обёртка вокруг flasm
=cut

use strict;
use warnings;

use Path::Tiny;

use Yandex::Shell;
use Yandex::Flasm::Patterns;

use base qw/Exporter/;
our @EXPORT = qw/
    flasm_parse_swf_file
    flasm_parse_swf_data
    flasm_parse_file
    flasm_parse_data
    flasm_decompile_file
    flasm_decompile_data
    /;

our $FLASM = '/usr/bin/flasm';

my @CONT_KEYWORDS = qw/
    frame defineButton defineMovieClip initMovieClip movie on onClipEvent placeMovieClip
    exportAssets importAssets importAssets2
    function function2 with try
    setTarget setTargetExpr ifFrameLoaded ifFrameLoadedExpr
    /;
my $CONT_RE = join "|", @CONT_KEYWORDS;

sub flasm_parse_swf_file {
    return flasm_parse_data(flasm_decompile_file(@_));
}

sub flasm_parse_swf_data {
    return flasm_parse_data(flasm_decompile_data(@_));
}

# декомпиляция swf вызовом внешней программы
sub flasm_decompile_data {
    my $data = shift;
    local $Yandex::Shell::CHDIR = 1;
    return yash_qx($FLASM, '-d', \$data);
}

# декомпиляция swf вызовом внешней программы
sub flasm_decompile_file {
    my ($file) = @_;
    if (!defined $file) {
        die "File is not defined";
    } elsif (!-f $file || !-r $file) {
        die "Incorrect file: '$file'";
    }
    local $Yandex::Shell::CHDIR = 1;
    my $text = yash_qx($FLASM, '-d', $file);
    return $text;
}

# парсинг файла
sub flasm_parse_file {
    my ($file) = @_;
    return flasm_parse_data(path($file)->slurp);
}

# парсинг текста программы
sub flasm_parse_data {
    my ($text, $additional_params) = @_;
    $text = flasm_patterns_replace($text, $additional_params);
    my @lines = map {s/^\s+|\s+$//g; $_} split /\n/, $text;
    # header/footer
    my $header = shift @lines;
    if ($header !~ /^movie\s/) {
        die "Incorrect flasm header: '$header'";
    }
    my $footer = pop @lines;
    if ($footer ne 'end') {
        die "Incorrect flasm footer: '$footer'";
    }
    # читаем контейнеры
    my $pos = 1;
    my $code = _read_code(\@lines, \$pos);
    return $code;
}

# внутренняя ф-ция по рекурсивному чтению ассемблера
sub _read_code {
    my ($lines, $rpos, $lvl) = @_;
    #print Dumper [read_code => $lines, $lvl];
    $lvl ||= 0;
    if (!@$lines) {
        return [];
    }
    my @code;
    while(@$lines) {
        my $line = shift @$lines;
        my $pos = ++$$rpos;
        if ($line =~ m!//\s*unknown\s*tag\s+(\d+)!) {
            push @code, {
                type => 'unknown',
                cmd => 'tag',
                pos => $pos,
                params => $1,
            };
            next;
        } elsif ($line =~ m!^\s*$!) {
            next;
        } elsif ($line =~ m!^\s*###\s*FlasmPattern:\s*(.*)!) {
            my $params = JSON::Syck::Load($1);
            push @code, {
                type => 'pattern',
                pos => $pos,
                params => $params,
            };
            $$rpos += $params->{lines} - 1;
            next;
        }
        my ($cmd, $params) = _parse_line($line);
        if ($cmd =~ /^($CONT_RE)$/) {
            push @code, {
                type => 'cont',
                cmd => $cmd,
                pos => $pos,
                params => $params,
                code => _read_code($lines, $rpos, $lvl+1),
            };
        } elsif ($cmd eq 'end') {
            die "Incorrect data: end at level 0" if !$lvl;
            return \@code;
        } elsif ($cmd =~ /^(.*):$/) {
            push @code, {
                type => 'label',
                cmd => $1,
                pos => $pos,
                params => '',
            };
        } elsif ($cmd =~ /^catch$/) {
            push @code, {
                type => 'catch',
                cmd => $1,
                pos => $pos,
                params => '',
            };
        } else {
            push @code, {
                type => 'oper',
                cmd => $cmd,
                pos => $pos,
                params => $params,
            };
        }
    }
    die "No end" if $lvl;
    return \@code;
}

# внутренняя ф-ция - глупый парсинг одной строки
sub _parse_line {
    my $line = shift;
    # получаем команду
    if ($line =~ /^(\d+)\s+as\s+(.*)/) {
        return ('as', "$1 $2");
    }
    my ($cmd, $params) = $line =~ /^([\w:]+)\s*(.*)$/;
    die "Incorrect line '$line'" if !$cmd;
    $params =~ s!\s*//[^']+$!!;
    return ($cmd, $params);
    ## парсим параметры
}

sub _parse_params {
    my $params = shift;
    $params =~ s/^\(|\)$//g;
    my @params;
    if ($params ne '') {
        my $qparam_re = qr!'(?:\\.|[^\\'])*'|[a-zA-Z0-9_:\.\-\+]+!;
        while($params =~ s/^($qparam_re)\,?\s*//) {
            push @params, $1;
        }
        die "Incorrect params '$params'" if !@params || $params;
    }
    return (@params);
}

1;
