package Yandex::Flasm::Patterns;

=head1 NAME

    Yandex::Flasm::Patterns

=head1 DESCRIPTION

    Заменить в коде flasm извесниые куски кода на заглушки

=cut

use strict;
use warnings;

use base qw/Exporter/;
our @EXPORT = qw/flasm_patterns_replace/;

use JSON::Syck;

use utf8;

my @patterns = (
    {
        pattern => "push 'onRelease' 
                    function2 () (r:1='_root') 
                        push r:_root, 'link1' 
                        getMember 
                        push '_blank' 
                        getURL2 
                    end // of function

                    set\\(Member\\|Variable\\)",
        data => {
            good_click => 1,
        }
    }, {
        pattern => "push 'onRelease' 
                    function () 
                      push '_root' 
                      getVariable 
                      push 'link1' 
                      getMember 
                      push '_blank' 
                      getURL2 
                    end // of function  
              
                    set\\(Member\\|Variable\\)",
        data => {
            good_click => 1,
        }
    }, {
        pattern => "push 'onRelease' 
                    function () 
                        push 'link1' 
                        getVariable 
                        push '_blank' 
                        getURL2 
                    end // of function  
  
                    set\\(Member\\|Variable\\)",
        data => {
            good_click => 1,
        }
    }, {
        pattern => "push '\\(\\w+\\)', 0.0, 'NetConnection' 
                    new 
                    \\(varEquals\\|setVariable\\)
                    push NULL, 1, '\\1' 
                    getVariable 
                    push 'connect' 
                    callMethod 
                    pop 
                    push '\\(\\w+\\)', '\\1'",

        data => {
            video => 1,
        }
    }, {
        pattern => "push \\d+\\(.\\d+\\)\\?, \\d+, \\d+\\(.\\d+\\)\\?, 'Sound' 
                    new 
                    push 'setVolume' 
                    callMethod",

        data => {
            sound => 1,
        }
    },
    {
        pattern => "push '_root'
                    getVariable
                    push 'link\\d+'
                    getMember
                    push '_blank'
                    getURL2
                    getURL 'javascript:home.expandableBannerAPI.close()' ''",

        data => {
            expandable_banner_api => 1,
            good_click => 1,
        }
    },
    );

=head2 $text = flasm_patterns_replace( $text )

=cut
sub flasm_patterns_replace {
    my $text = shift;
    my $params = shift;

    for my $p (@patterns) {
        my ($rows_number, $pattern) = _process_pattern($p->{pattern});

        if( exists($p->{data}->{video}) ){
            $p->{data}->{video} = _check_video_correctness($text, $pattern, $params);
        }

        my $json_data = JSON::Syck::Dump( {lines => $rows_number, %{$p->{data}}} );
        $text =~ s/\n$pattern\n/\n### FlasmPattern: $json_data\n/g;
    }
    return $text;
}

sub _process_pattern
{
    my $pattern = shift;

    my @plines = map {s/^\s+|\s+$//g; $_;} split /\n/, $pattern;
    $pattern = join "\n", map {"\\s*\Q$_\E\\s*"} @plines;

    # заменяем \\\( -> (
    $pattern =~ s/ \\ \\ \\ ( \( | \) | \| ) /$1/xg;

    # приводим в порядок метапоследовательности, например \\w\+ -> \w+
    $pattern =~ s{\\\\([wWdDsS])\\([+*])}{\\$1$2}xg;
    $pattern =~ s{\\ \\ \\ \?}{?}xg;

    # приводим в порядок обратные ссылки, пример: \\1 -> \1 
    $pattern =~ s/\\ ( \\ \d )/$1/xg;

    return (scalar(@plines), $pattern);
}

sub _check_video_correctness
{
    my $text = shift;
    my $pattern = shift;
    my $params = shift;
    my $ok = undef;

    my ($connection_name, $operation, $object_name) = $text =~ m/$pattern/;                                                                                                     

    if($object_name){ 

        my $allowed_vars = '\w+';
        if(exists $params->{video}->{vars} and @{$params->{video}->{vars}} > 0){
            $allowed_vars = join('|', @{$params->{video}->{vars}});
            $allowed_vars = "($allowed_vars)";
        }

        my $play_call_method = qr{
                    (push r:_root, '$allowed_vars'
                    getMember
                    push 1, '$object_name'
                    getVariable 
                    push 'play' 
                    callMethod)
                    |
                    (push '$allowed_vars' 
                    (getMember|getVariable) 
                    push 1, '$object_name' 
                    getVariable 
                    push 'play' 
                    callMethod)
        };

        $play_call_method =~ s{(^\s*)|(\s*$)}{\\s*}mg;

        $ok = 1 if $text =~ m/$play_call_method/x;
    }
    return $ok;
}

1;
