package Yandex::SafeSWF::Dump;

use strict;
use warnings;

use Yandex::Shell;
use Yandex::SafeSWF::Tags;

our $SWFDUMP_PROG = '/usr/bin/swfdump';

use base qw/Exporter/;
our @EXPORT = qw/
    swfdump_check_data
    is_swfdump_available
/;

sub is_swfdump_available {
    return -x $SWFDUMP_PROG;
}

sub swfdump_check_data {
    my $data = shift;
    # получаем из дампа список тегов
    my $swf_dump = yash_qx($SWFDUMP_PROG, \$data);
    # удаляем разрывы строк в ==== Error:
    sub norm_space {my $t=shift; $t =~ s/\s+/ /g; $t};
    $swf_dump =~ s/(==== Error: .*?====)\s*\n(\s+)/norm_space($1).$2/gse;
    my @tags;
    for my $line (split /\n/, $swf_dump) {
        if ($line =~ /^==== Error: Unknown tag:0x([0-9a-f]+)/) {
            push @tags, { num => hex($1), name => undef };
        } elsif ($line =~ /^\[ HEADER \] /xi) {
            # заголовки все пропускаем
            #push @tags, { num => 0, name =>  };
        } elsif ($line =~ /^\s+exports/xi) {
        } elsif ($line =~ /^\s*$/xi) {
        } elsif ($line =~ /^\[ ([0-9a-f]+) \] \s+ \d+ \s+ ([\(\)a-z0-9]+) /xi) {
            push @tags, { num => hex($1), name => $2 };
        } else {
            die "Incorrect string: '$line'";
        }
    }
    # проверяем теги
    my %bad_tags;
    for my $tag (@tags) {
        my $tagname = defined $tag->{name} && $tag->{name} ne '(null)' ? $tag->{name} : tag_name($tag->{num});
        if (!is_tag_safe($tagname)) {
            $bad_tags{$tagname}++;
        }
    }
    return %bad_tags;
}

1;
