package Yandex::SafeSWF::Mill;

=head1 NAME

    Yandex::SafeSWF::Mill - проверка swf с помощью swfmill

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use XML::LibXML;

use Yandex::Shell;
use Yandex::SafeSWF::Tags;

our $SWFMILL_PROG = '/usr/bin/swfmill';

use base qw/Exporter/;
our @EXPORT = qw/
    swfmill_check_data
    is_swfmill_available
/;

=head2 is_swfmill_available()

    Установлен ли в системе swfmill

=cut
sub is_swfmill_available {
    return -x $SWFMILL_PROG;
}

=head2 swfmill_check_data(DATA)

    Проверить swf (в скаляре) на содержание вредных тегов
    Вернуть хэш - вредный тег: сколько раз встретился

=cut
sub swfmill_check_data {
    my $data = shift;
    # получаем из дампа список тегов
    my $xml = yash_qx($SWFMILL_PROG, 'swf2xml', \$data);

    my $el = XML::LibXML->new()->parse_string($xml)->documentElement();            
    my @tags_els = map {$_->tagName eq 'UnknownTag' ? tag_name(hex $_->getAttribute('id')) : $_->tagName } $el->findnodes("//tags/*");

    # проверяем теги
    my %bad_tags;
    for my $tag (@tags_els) {
        if (!is_tag_safe($tag)) {
            $bad_tags{$tag}++;
        }
    }
    return %bad_tags;
}

1;
