package Yandex::SafeSWF::Tags;

=head1 NAME

    Yandex::SafeSWF::Tags - список безопасных тэгов

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use base qw/Exporter/;
our @EXPORT = qw/
    is_tag_safe
    tag_name
/;

my %SAFE_TAGS = map {uc($_) => 1} qw/
    DEFINEBITS DEFINEBITSJPEG2 DEFINEBITSJPEG3 DEFINEBITSLOSSLESS DEFINEBITSLOSSLESS2
    DEFINEBUTTON2 DEFINEBUTTONSOUND DEFINEEDITTEXT DEFINEFONT DEFINEFONT2 DEFINEFONTINFO
    DEFINEFONTINFO2 DEFINEMORPHSHAPE DEFINESHAPE DEFINESHAPE2 DEFINESHAPE3 DEFINESOUND
    DEFINESPRITE DEFINETEXT DEFINETEXT2 DEFINEVIDEOSTREAM

    DOACTION DOINITACTION
    END

    ENABLEDEBUGGER ENABLEDEBUGGER2
    EXPORTASSETS FILEATTRIBUTES EXPORT
    FRAMELABEL
    FREECHARACTER
    JPEGTABLES
    METADATA
    MX4
    PLACEOBJECT PLACEOBJECT2 PLACEOBJECT3
    PROTECT
    REMOVEOBJECT REMOVEOBJECT2
    SETBACKGROUNDCOLOR
    SHOWFRAME
    SOUNDSTREAMBLOCK
    SOUNDSTREAMHEAD2
    STARTSOUND
    VIDEOFRAME

    Protect
    PathsArePostscript

    ScriptLimits
    SetTabIndex

    FileAttributes
    JPEGTables
    PlaceObject3
    Import2
    DefineFontAlignZones
    CSMTextSettings
    DefineFont3
    Metadata
    DefineScalingGrid
    DefineShape4
    DefineMorphShape2
    DefineShape5
    DefineFontInfo3

    DefineFontName
/;

my %UNKNOWN_TAG_NAMES = (
    8  => 'JPEGTables',
    24 => 'Protect',
    25 => 'PathsArePostscript',
    # SWF Version 7.0
    65 => 'ScriptLimits',
    66 => 'SetTabIndex',
    # SWF Version 8.0
    69 => 'FileAttributes',
    70 => 'PlaceObject3',
    71 => 'Import2',
    73 => 'DefineFontAlignZones',
    74 => 'CSMTextSettings',
    75 => 'DefineFont3',
    77 => 'Metadata',
    78 => 'DefineScalingGrid',
    83 => 'DefineShape4',
    84 => 'DefineMorphShape2',
    # SWF Version 9.0
    88 => 'DefineFontName',

    72 => 'DoABC',
    76 => 'SymbolClass',
    82 => 'DoABCDefine',
    86 => 'DefineSceneAndFrameData',
    87 => 'DefineBinaryData',
);

=head2 is_tag_safe('DefineFontName')

    Проверить, безопасен ли тег по имени.

=cut
sub is_tag_safe {
    my $tagname = shift;
    return $SAFE_TAGS{uc($tagname)};
}

=head2 tag_name(88)

    По номеру тега получить имя 
    Работает не для всех номеров, а только для тех, которые неизвестны swfdump/swfmill

=cut
sub tag_name {
    my $tag_num = shift;
    return $UNKNOWN_TAG_NAMES{$tag_num} || "UNKNOWN-$tag_num";
}

1;
