#!/usr/bin/perl -w

use strict;
use Data::Dumper;
use Test::More tests => 2;
use Test::Deep;

use Yandex::Flasm;

use utf8;
use open ':std' => ':utf8';

sub pl {
    my $str = shift;
    my @ret = Yandex::Flasm::_parse_line($str);
    #print Dumper \@ret;
    return \@ret;
}

cmp_deeply(pl("end // asdf asd zxcv : 123"), ['end', '']);

cmp_deeply(pl("123 as 'asdf:234'"), ['as', "123 'asdf:234'"]);

#cmp_deeply(pl("defineMovieClip 15 // total frames: 15"), ['defineMovieClip', 15]);
#
#cmp_deeply(pl("defineMovieClip 15,  188 // total frames: 15"), ['defineMovieClip', 15, 188]);
#
#cmp_deeply(pl("setRegister r:N"), ['setRegister', 'r:N']);
#
#
#cmp_deeply(pl("push 'link1'"), ['push', "'link1'"]);
#cmp_deeply(pl("push 1, 2, 'gotoAndStop'"), ['push', 1, 2, "'gotoAndStop'"]);
#cmp_deeply(pl("push 'rnd', 'x', 1.2, 'Math'"), ['push', "'rnd'", "'x'", "1.2", "'Math'"]);
#
#cmp_deeply(pl("function ('t', 'b')"), ['function', "'t'", "'b'"]);
#cmp_deeply(pl("function ()"), ['function']);

#cmp_deeply(pl("157 as 'starr'"), ['as', '157', 'starr']);
#cmp_deeply(pl("placeMovieClip 1 as 'mainN'"));
#cmp_deeply(pl("push '', 1, -2"));
#cmp_deeply(pl("function2 () (r:1='this')"));
