#!/usr/bin/perl -w

use strict;
use Test::More tests => 3;
use Test::Deep;

use Cwd;
use File::Basename;
use Data::Dumper;
use YAML::XS;

use Yandex::Flasm;

use utf8;
use open ':std' => ':utf8';

my $DIR = dirname(Cwd::realpath($0))."/data";

sub fpf {
    my $file = shift;
    my $ret = Yandex::Flasm::flasm_parse_file("$DIR/$file.flm");
    return $ret;
}
sub yml {
    my $file = shift;
    return YAML::XS::LoadFile("$DIR/$file.yaml");
}

cmp_deeply(fpf("simple"), yml("simple"));

cmp_deeply(fpf("frame"), yml("frame"));

cmp_deeply(fpf("as"), yml("as"));

