#!/usr/bin/perl -w

use strict;
use Test::More;
use Test::Deep;
use List::MoreUtils qw/uniq/;

use Cwd;
use File::Basename;
use File::Find;
use Data::Dumper;
use Path::Tiny;
use JSON;

use Yandex::Flasm;
use Yandex::SafeSWF;

use utf8;
use open ':std' => ':utf8';

my $DIR = dirname(Cwd::realpath($0))."/data";

# ищем все тестовые файлы
my @files;
find(
    sub {
        if (/\.flm$/ && -f $File::Find::name) {
            push @files, $File::Find::name;
        }
    },
    $DIR
    );
Test::More::plan(tests => scalar(@files));

sub cc {
    my ($cont, $link_limits, $additional_parameters) = @_;
    my $code = Yandex::Flasm::flasm_parse_data($cont, $additional_parameters);
    Yandex::SafeSWF::_init_check($link_limits);
    return Yandex::SafeSWF::_check_code($code, undef, $additional_parameters);
}

for my $file (sort @files) {
  SKIP: {
      my ($name) = $file =~ /([^\/]+)\.flm$/;
      (my $cont = path($file)->slurp) =~ s!//\s*SafeSWF(?:\((\d+)\))?:\s*([^\n:]+)(\s*({.+})\s*)?\n!!;
      my $links_limit = $1;
      my ($planned_res) = $2 || '';
      my $additional_parameters = decode_json($3) if $3;
      #print Dumper($additional_parameters) if $additional_parameters;

      my $res;
      if ($planned_res =~ /^OK/) {
          $res = '';
      } elsif ($planned_res =~ /^SKIP(.*)/) {
          skip "Not implemented yet", 1;
      } elsif ($planned_res =~ /^FAIL\s*(.*?)\s*$/) {
          $res = $1;
      } else {
          fail("Undefined test result for $name");
      }
      my @errors = cc($cont, $links_limit, $additional_parameters);
      my $errs = join ',', sort {$a cmp $b} uniq map {$_->{err}} @errors; 
      print Dumper \@errors if $ENV{DEBUG} && $errs ne $res;
      is($errs, $res, "Checking $name");
    }
}
