package Yandex::Template::Plugin::Checksum;

=pod
    $Id$
    Плагин для вычисления Adler32 checksum
=cut

use strict;
use warnings;
use base qw( Template::Plugin );
use Template::Plugin;

use Digest::Adler32;

use utf8;

sub new {
    my ($class, $context, @params) = @_;
    bless {
        _CONTEXT => $context,
    }, $class;
}

sub adler32 {
    my ($self,$string) = @_;
    return hex(Digest::Adler32->new()->add($string)->hexdigest);
}

1;
