package Yandex::Template::Plugin::Dateformat;

use strict;
use warnings;
use base qw( Template::Plugin );
use Template::Plugin;
use POSIX ();
use Time::Local;
use utf8;

sub new {
    my ($class, $context, @params) = @_;
    bless {
        _CONTEXT => $context,
    }, $class;
}

sub short_month_name {
    my $self = shift;
    my $i = sprintf("%u", shift);
    $i=0 if(!defined $i || $i>11 || $i<0);
    return qw(янв фев мар апр май июн июл авг сен окт ноя дек)[$i];
}
sub full_month_name {
    my $self = shift;
    my $i = sprintf("%u", shift);
    $i=0 if(!defined $i || $i>11 || $i<0);
    return qw(январь февраль март апрель май июнь июль август сентябрь октябрь ноябрь декабрь)[$i];
}

sub strftime {
    my ($self,$format,@arg) = @_;
    $format = "%Y%m%d" unless($format);
    return POSIX::strftime($format,@arg);
}

sub ucfirst {
    my ($self,$string) = @_;
    return CORE::ucfirst($string);
}

sub format_date {
    my ( $self, $date, $dateagg, $no_html ) = @_;
    return $date if($date !~ m!^(\d{4})\D*(\d{2})?\D*(\d{2})?$!);
    my ( $yyyy, $mm, $dd ) = ($1,$2,$3);
    $dd=1 unless($dd);
    $mm=1 unless($mm);

    my $tm = timelocal(0, 0, 0, $dd, $mm-1, $yyyy-1900);
    if ( $dateagg && $dateagg eq 'week' ) {
        return join(($no_html?' - ':' &ndash; '), POSIX::strftime("%d.%m.%y", localtime($tm)), POSIX::strftime("%d.%m.%y", localtime($tm+6.1*24*60*60)));
    } elsif ( $dateagg && $dateagg eq 'month' ) {
        return $self->short_month_name($mm-1) ." $yyyy";
    } elsif ( $dateagg && $dateagg eq 'month_full' ) {
        return $self->full_month_name($mm-1) ." $yyyy";
    } elsif ( $dateagg && $dateagg eq 'year' ) {
        return $yyyy;
    } else {
        return POSIX::strftime("%d.%m.%Y", localtime($tm));
    }
}

1;
