package Yandex::Template::Plugin::Env;

# $Id$

=head1 NAME

    Yandex::Template::Plugin::Env

=head1 SYNOPSIS

    [%
        USE Env;
        Env.env('QUERY_STRING')
    %]

=head1 DESCRIPTION

    Плагин Template для обращений к переменным окружения

=cut

use strict;
use warnings;
use base qw( Template::Plugin );
use Template::Plugin;

use utf8;

sub new {
    my ($class, $context, @params) = @_;
    bless {
        _CONTEXT => $context,
    }, $class;
}

=head2 env(key)

    Получение переменной окружения по ключу

=cut
sub env {
    my ($self, $key) = @_;
    return $ENV{$key};
}

1;
