package Yandex::Template::Profile;

# $Id$

=head1 NAME

    Yandex::Template::Profile

=head1 DESCRIPTION

    Простейшее профилирование шаблонов.
    Большей частью украдено у Randal L. Schwartz

=head1 SYNOPSIS

    # отслеживание только общего времени выполнения шаблона через Yandex::Profile
    use Yandex::Template::Profile qw/global/;

    # вывод в STDERR детального профиля выполнения шаблона
    use Yandex::Template::Profile qw/detail/;

=cut

use strict;
use Template;

sub import {
    shift;
    if (!@_) {
        @_ = qw/global/;
    }
    for (@_) {
        if ($_ eq 'global') {
            require Yandex::Template::Profile::Service;
            $Template::Config::SERVICE = 'Yandex::Template::Profile::Service';
        } elsif ($_ eq 'detail') {
            require Yandex::Template::Profile::Context;
            require Yandex::Template::Profile::Stash;
            $Template::Config::CONTEXT = 'Yandex::Template::Profile::Context';
            $Template::Config::STASH = 'Yandex::Template::Profile::Stash';
        } else {
            die "Incorrect Yandex::Template::Profile option: $_";
        }
    }
}

1;


