package Yandex::Template::Profile::Context;

use strict;
use Time::HiRes qw//;
use Yandex::Template::Profile::Stash;
use base qw(Template::Context);

my @context_stack;
my %context_totals;

sub process {
    my $self = shift;

    my $template = $_[0];
    if (UNIVERSAL::isa($template, "Template::Document")) {
        $template = $template->name || $template;
    }

    push @context_stack, [Time::HiRes::time(), times];

    local $@;
    my @return = eval {
        wantarray ?
            $self->SUPER::process(@_) :
            scalar $self->SUPER::process(@_)
            };
    my $err = $@;

    my @delta_times = @{pop @context_stack};
    @delta_times = map { $_ - shift @delta_times } Time::HiRes::time(), times;
    for (0..$#delta_times) {
        $context_totals{$template}[$_] += $delta_times[$_];
    }
    $context_totals{$template}[5] ++;     # count of calls

    unless (@context_stack) {
        ## top level again, time to display results
        print STDERR "-- $template at ". localtime, ":\n";
        printf STDERR "%6s %8s %8s %8s %8s %8s %s\n",
            qw(cnt clk user sys cuser csys template);
        for my $template (sort { $context_totals{$b}->[0] <=> $context_totals{$a}->[0] } keys %context_totals) {
            my @values = @{$context_totals{$template}};
            printf STDERR "%6d %8.3f %8.3f %8.3f %8.3f %8.3f %s\n",
            $values[5], @values[0..4], $template;
        }
        print STDERR "-- end\n";
        %context_totals = ();               # clear out results
        Yandex::Template::Profile::Stash::print_profile();
    }

    die $err if $err;
    # return value from process:
    wantarray ? @return : $return[0];
}

1;
