package Yandex::Template::Profile::Stash;

use strict;
use Time::HiRes qw//;
use base qw(Template::Stash::XS);

my %stash_totals;
use constant TOP_N => 100;

sub get {
    my $self = shift;

    my $name = get_full_var_name($_[0]);

    my @times = (Time::HiRes::time(), times);

    my @return = wantarray ?
        $self->SUPER::get(@_) :
        scalar $self->SUPER::get(@_);

    my @delta_times = map { $_ - shift @times } Time::HiRes::time(), times;
    for (0..$#delta_times) {
        $stash_totals{$name}[$_] += $delta_times[$_];
    }
    $stash_totals{$name}[5] ++;     # count of calls

    wantarray ? @return : $return[0];
}

sub get_full_var_name {
    if (!ref $_[0]){
        return $_[0];
    } elsif (ref $_[0] eq 'ARRAY') {
        return '['.join(',', map {ref $_ eq 'ARRAY' ? '[]' : ref $_ eq 'HASH' ? '{}' : scalar($_)} @{$_[0]}).']';
        #return '()';
        #return '('.join('.',map {get_full_var_name($_)} @{$_[0]}).')';
    } elsif (ref $_[0] eq 'HASH') {
        return '{}';
    }
}

sub print_profile {
    print STDERR "-- Stash gets at ". localtime, ":\n";
    printf STDERR "%6s %8s %8s %8s %8s %8s %s\n",
        qw(cnt clk user sys cuser csys template);
    my $i = 0;
    for my $name (sort { $stash_totals{$b}->[0] <=> $stash_totals{$a}->[0] } keys %stash_totals) {
        last if $i++ >= TOP_N;
        my @values = @{$stash_totals{$name}};
        printf STDERR "%6d %8.3f %8.3f %8.3f %8.3f %8.3f %s\n",
	                   $values[5], @values[0..4], $name;
    }
    print STDERR "-- end\n";
    %stash_totals = ();
}

1;
