package Yandex::Template::Provider::Encoded;

=pod
    $Id$
    Провайдер для Template-toolkit, который позволяет хранить шаблоны не в utf и 
    перекодировать их на лету
    Использовать нуж но примерно так: при создании объекта Template нужно передать параметр
    LOAD_TEMPLATES => [ Yandex::Template::Provider::Encoded->new( encoding => 'utf8' ) ]
=cut

use strict;
use Encode;
use base qw/Template::Provider/;

sub new {
    my $class = shift;
    my %params = @_;
    my $self = Template::Provider->new( %params );
    bless $self;
    return $self;
}

sub _load {
    my $self = shift;
    my @res = $self->SUPER::_load(@_);
    if ( $self->{PARAMS}->{encoding} && !Encode::is_utf8($res[0]->{text}) ) {
        $res[0]->{text} = Encode::decode($self->{PARAMS}->{encoding}, $res[0]->{text});
    }
    return @res;
}

1;
