#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use Time::HiRes qw//;
use feature 'state';
use lib::abs '../lib';
use lib '/var/www/ppc.yandex.ru/perl/settings';
$|++;

# to get nytprof stats:
# perl -d:NYTProf aux/bench.pl  

use Settings;

use Yandex::Trace;
use Yandex::DBTools;
use Benchmark qw/:all/;

my $func_cnt = 10;
my $tags_cnt = 10;

sub _func_name
{
    state $idx = 0;
    $idx = ($idx + 1) % $func_cnt;
    return shift."_$idx";
}

sub _tag_name
{
    state $idx = 0;
    $idx = ($idx + 1) % $tags_cnt;
    return shift."_$idx";
}

sub just_math
{
    my $sum = 0;
    for (1 .. 1000) {
        $sum += $_;
    }
    return $sum;
}

sub math_with_profile
{
    my $profile = Yandex::Trace::new_profile(_func_name('math_with_profile'), tags => _tag_name('math'));
    my $sum = 0;
    for (1 .. 1000) {
        $sum += $_;
    }
    return $sum;

}

sub just_query
{
    return get_one_field_sql(PPCDICT, 'select 1');
}

sub query_with_profile
{
    my $profile = Yandex::Trace::new_profile(_func_name('query_with_profile'), tags => _tag_name('query'));
    return get_one_field_sql(PPCDICT, 'select 1');
}

for my $i (2 .. 17) {
    my $cnt = 2**$i;
    my $trace = Yandex::Trace->new(service => 'test', method => 'benchmark');
    my $p0 = Yandex::Trace::new_profile('p0');
    my $t0 = Time::HiRes::time();
    for (1 .. $cnt) {
        my $p = Yandex::Trace::new_profile('p');
    }
    my $t = Time::HiRes::time() - $t0;
    printf "%d: %.6f\n", $cnt, $t/$cnt;
}

my $trace = Yandex::Trace->new(service => 'test', method => 'test');

__END__
cmpthese(-3, {
    just_math => \&just_math,
    math_with_profile => \&math_with_profile,
    just_query => \&just_query,
    query_with_profile => \&query_with_profile,
});

__END__
                      Rate query_with_profile just_query math_with_profile just_math
query_with_profile  3125/s                 --        -2%              -74%      -79%
just_query          3195/s                 2%         --              -74%      -79%
math_with_profile  12195/s               290%       282%                --      -18%
just_math          14925/s               378%       367%               22%        --

##################

    
# spent 70.3ms (26.4+43.9) within Yandex::Trace::new_profile which was called 2000 times, avg 35µs/call:
# 1000 times (15.5ms+25.3ms) by main::query_with_profile at line 42 of aux/bench.pl, avg 41µs/call
# 1000 times (11.0ms+18.6ms) by main::math_with_profile at line 26 of aux/bench.pl, avg 30µs/call

Calls   P   F   Exclusive
Time    Inclusive
Time    Subroutine
20003   2   1   29.8s   29.8s                  DBI::st::execute (xsub)
10000   1   1   1.54s   1.87s                     main::math_with_profile
10000   1   1   1.44s   1.44s                     main::just_math
20000   1   1   931ms   3.96s          Yandex::DBTools::_log_query
20001   2   2   701ms   2.91s              Yandex::Log::out
40005   1   1   642ms   728ms   Yandex::Profile::Timer::new
20000   1   1   398ms   31.1s          Yandex::DBTools::_sth_execute
20000   1   1   368ms   37.3s          Yandex::DBTools::_exec_sql_wrapper
20000   1   1   317ms   510ms                     JSON::to_json
40000   2   1   316ms   504ms          Yandex::DBTools::_get_statement_type
20000   1   1   286ms   466ms          Yandex::DBTools::soft_reconnect_db
20000   2   1   281ms   38.1s          Yandex::DBTools::get_one_field_sql
20000   2   1   255ms   672ms            Yandex::Trace::new_profile
40005   5   2   245ms   283ms   Yandex::Profile::Timer::DESTROY
20001   1   1   235ms   235ms               IO::Handle::CORE:print (opcode)

