#!/usr/bin/perl

use common::sense;
use Path::Tiny;
use JSON;
use POSIX qw/strftime/;
use Yandex::ListUtils qw/xminus xisect/;
use List::MoreUtils qw/after/;
$|++;

my $dir = shift // '/var/www/ppc.yandex.ru/protected/logs/';
my $date = shift // strftime("%Y%m%d", localtime(time));

my $trace = path($dir, "trace.log.$date");
my $profile = path($dir, "profile.log.$date");

if (!$trace->is_file) {
    die "$trace not found\n";
}

if (!$profile->is_file) {
    die "$profile not found\n";
}

#[3,"2015-04-13 11:30:10.455115","ppcdev2.yandex.ru","23593","Direct.Web","clientWallet","",3145977594980700311,0,3145977594980700311,1,true,0.497380018234253,1,{"profile":[["process_bem","",0.155578136444092,0,1,1],["Check","",0.0238316059112549,0,11,11],["is_alive","",0.00182700157165527,0,1,1],["GetClientIdsByUids","",0.00742602348327637,0,4,4],["GetUserRoles","",0.00479912757873535,0,2,2],["InitReq","",0.00412297248840332,0,1,1],["rest","",0.299795150756836,0,1,0]],"services":[],"marks":[],"times":{"ela":0.497380018234253,"cu":0.01,"cs":0.02,"mem":632},"annotations":[]}]
my $trace_fh = $trace->openr();
my %trace_by_id =
    #map { my $r = eval { from_json($_) } // die "$_ : $@"; ( $r->[7] => $r ) }
    map { my $r = eval { from_json($_) } // []; ($r->[7]//'' => $r) }
    <$trace_fh>;

print STDERR "read $trace\n";

# 2015-04-13      14:34:09        JSON-API/GetBanners     3146240773287144453     total:0.182,u:0.030,s:0.020,cu:0.000,cs:0.000,mem:0     Yandex::DBTools::_sth_execute#db=ppc:1~read: 0.038/22/0        rest#: 0.029/1/0        Yandex::Blackbox::bb_method#method=oauth: 0.028/1/0     Yandex::DBTools::_sth_execute#db=ppcdict~read: 0.011/7/0        Yandex::Memcached::_mc_request#op=gets: 0.009/1/0      Yandex::Memcached::_mc_request#op=get_multi: 0.009/1/0  Yandex::Memcached::_mc_request#op=set: 0.009/1/0        Yandex::Memcached::_mc_request#op=delete: 0.009/1/0    Yandex::Memcached::_mc_request#op=add: 0.009/1/0        Yandex::Memcached::_mc_request#op=incr: 0.009/1/0       Yandex::Log::out#: 0.005/45/0  RBAC2::Extended::Check#: 0.005/2/0      RBAC2::Extended::_InitReq#: 0.003/1/0   Yandex::DBTools::_sth_execute#db=ppclog~write: 0.003/2/0        API::JSON::handler#op=from_json: 0.003/1/0     RBAC2::Extended::GetUserRoles#: 0.002/1/0       RBAC2::Extended::_is_alive#: 0.002/1/0  Plack::NormalizeResponse::normalize#type=json: 0.000/1/0      Yandex::I18n::init_i18n#: 0.000/2/0      BSAuction::bs_get_phrases_statuses#: 0.000/1/0
my $profile_fh = $profile->openr();
my %profile_by_id =
    map { my ($date,$time,$cmd,$reqid,@profile) = split /\t/, $_; ($reqid => [$cmd, @profile]) }
    grep { /\w/ }
    map { chomp; $_ }
    <$profile_fh>;

print STDERR "read $profile\n";

#{ use Data::Dump 'pp'; my $p = pp({ t => \%trace_by_id, p => \%profile_by_id }); $p =~ s#\\x\{([\da-f]{2,4})\}#chr(hex($1))#gei; print STDERR "$p\n"; } # NO_PRODUCTION

my $matched = xisect [keys %trace_by_id], [keys %profile_by_id];

printf "%d in trace, %d in profile, %d in common\n", scalar keys %trace_by_id, scalar keys %profile_by_id, scalar @$matched;

my $trace_only = xminus [keys %trace_by_id], $matched;

if (@$trace_only) {
    printf "trace only: %d\n", scalar @$trace_only;
    print ''.(join "\n", map { join "\t", ($_, $trace_by_id{$_}->[4], $trace_by_id{$_}->[5]) } @$trace_only)."\n";
}

my $profile_only = xminus [keys %profile_by_id], $matched;

if (@$profile_only) {
    printf "profile only: %d\n", scalar @$profile_only;
    print ''.(join "\n", map { "$_\t".$profile_by_id{$_}->[0] }  @$profile_only)."\n";
}



