#!/usr/bin/perl

use common::sense;
use Path::Tiny;
use JSON;
use POSIX qw/strftime/;
use IO::Uncompress::Gunzip qw/$GunzipError/;
# use Yandex::ListUtils qw/xminus xisect/;
# use List::MoreUtils qw/after/;
# use DBI;
use Getopt::Long;
use Time::HiRes;
$|++;

GetOptions(\my %opt,
    "load|l",
    "prefix|p=s",
);

if ($opt{load}) {
    load_logs();
    exit;
}

if ($opt{compare}) {
    compare_logs();
    exit;
}


sub load_logs
{
    my $dir = shift @ARGV // '.';
    my $date = shift @ARGV // strftime("%Y%m%d", localtime(time));

    print "$dir\n";
    
    my $prefix = $opt{prefix} || '';
    if ($prefix) {
        $prefix = $prefix."_";
    }
    
    path('./tmp/')->mkpath();
    my $trace_reqid = path("./tmp/${prefix}trace_reqid.$date.log");
    my $trace_reqid_fh = $trace_reqid->openw();

    my $profile_reqid = path("./tmp/${prefix}profile_reqid.$date.log");
    my $profile_reqid_fh = $profile_reqid->openw();

    # my $trace = path($dir, "trace.log.$date");
    # my $profile = path($dir, "profile.log.$date");

    # if (!$trace->is_file) {
    #     die "$trace not found\n";
    # }
    #
    # if (!$profile->is_file) {
    #     die "$profile not found\n";
    # }
    my $json = JSON->new()->utf8(1);

    # print "$trace";
    my $t0 = Time::HiRes::time();

    
    my $trace_fh = get_log_fh($dir, $date, "trace");
    return unless $trace_fh;
    while (<$trace_fh>) {
        chomp;
        unless (/^\[/) {
            # no_date made no effect sometimes, cut date
            s!^[\d\-]+\s+[\d\:]+\s+!!;
        }
        my $row = eval { $json->decode($_) };
        next unless $row;
        next unless $row->[11]; # completed
        print $trace_reqid_fh $row->[7]."\n"
    }
    
    printf " ... %.2f\n", Time::HiRes::time() - $t0;
    $t0 = Time::HiRes::time();

    # print "$profile";
    
    my $profile_fh = get_log_fh($dir, $date, "profile");
    return unless $profile_fh;
    while (<$profile_fh>) {
        chomp;
        my ($date,$time,$cmd,$reqid,@profile) = split /\t/, $_;
        print $profile_reqid_fh "$reqid\n";
        # last if $. > 100;
    }
    printf " ... %.2f\n", Time::HiRes::time() - $t0;
    close $trace_reqid_fh;
    close $profile_reqid_fh;

    print "sort $trace_reqid\n";
    system "sort -u $trace_reqid | sponge $trace_reqid";
    
    print "sort $profile_reqid\n";
    system "sort -u $profile_reqid | sponge $profile_reqid\n";

    print "diff\n";
    system "git diff $trace_reqid $profile_reqid > tmp/${prefix}trace_profile_diff.log"
}

sub get_log_fh
{
    my ($dir, $date, $name) = @_;
    my ($dir, $date) = @_;
    my $log = path($dir, "$name.log.$date");
    if ($log->exists) {
        print "$log";
        return $log->openr_utf8();
    }
    my ($month) = ($date =~ /^(\d{6})/);
    die unless $month;
    $log = path($dir, $month, "$name.log.$date.gz");
    if ($log->exists) {
        print "$log";
        my $fh = $log->openr;
        my $z = new IO::Uncompress::Gunzip $fh or die("gunzip failed: $GunzipError\n");
        return $z;
    }
    return;
}
