#!/usr/bin/perl

use Test::More;
use Test::Exception;
use Yandex::Trace;

$Yandex::Log::LOG_ROOT = '/tmp';

ok(!defined Yandex::Trace::current_span_id, 'current_span_id is undef before trace initialized');

my $trace = Yandex::Trace->new(method => 'test', service => 'test_service');
ok($trace->method() eq 'test');

$trace->method("new_test");
ok($trace->method() eq 'new_test');

my $reqid = $trace->trace_id();
ok($reqid == Yandex::Trace::trace_id(), "accessors work as static methods");

dies_ok { Yandex::Trace::trace_id(42) } "static methods dies with param";

ok(my $span_id = $trace->span_id, 'span_id ok');
my $trace_nested = Yandex::Trace->new(method => 'sub_test', service => 'sub_test_service', trace_id => $trace->trace_id, span_id => '1235');
ok($trace->span_id eq $span_id, 'span_id of root trace stays');
ok($trace_nested->span_id eq $trace->current_span_id && $trace->current_span_id eq '1235', 'current span_id changed on child spawn');

done_testing();
