#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::Deep;
use Test::MockTime qw(:all);
use List::Util qw/first/;
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

mock_hires();
set_fixed_time(time);

my $trace = Yandex::Trace->new(method => 'test', service => 'test');

test_sleep(5);

$trace->annotate( k => 'v' );

$trace->flush();

my $r = get_last_log();
my $ann = $r->[$INDEX->{DATA}]->{annotations};
ok(ref $ann eq 'ARRAY', "anns is array");
ok(scalar @$ann == 1, "ann in log");
ok($ann->[0]->[0] eq 'k', "ann key");
ok($ann->[0]->[1] eq 'v', "ann value");


done_testing();


