#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::MockTime qw(:all);
use List::Util qw/first/;
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

=head2

тестируем случай, когда вложенные таймеры удаляются в том же порядке, в каком были созданы:

my $t1 = Yandex::Trace::new_profile(...);
get_data();
my $t2 = Yandex::Trace::new_profile(...);
process_data();
undef $t1;
write_data();
undef $t2;

Практический смысл такого кода? Какие значения должны попасть в profile? В частности,
каким должен быть childs_ela если родитель завершился раньше детеныша?

=cut

use lib::abs '../lib';
do(lib::abs::path('.')."/_test_common.pl");
BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

mock_hires();
set_fixed_time(time);

my $trace = Yandex::Trace->new(method => 'test', service => 'test');

my $t1 = Yandex::Trace::new_profile('f1');
test_sleep(1);
my $t2 = Yandex::Trace::new_profile('f2');
test_sleep(2);
undef $t1;
test_sleep(3);
undef $t2;
$trace->flush();

my $r = get_last_log();

my $pr_f1 = first { $_->[$PROFILE_INDEX->{FUNC}] eq 'f1' } @{$r->[14]->{profile}};
my $pr_f2 = first { $_->[$PROFILE_INDEX->{FUNC}] eq 'f2' } @{$r->[14]->{profile}};

ok($pr_f1->[$PROFILE_INDEX->{ALL_ELA}] == 3, "first half-nested profile");
ok($pr_f2->[$PROFILE_INDEX->{ALL_ELA}] == 5, "snd half-nested profile");


done_testing();

