#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::MockTime qw(:all);
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

mock_hires();
set_fixed_time(time);

my $trace = Yandex::Trace->new(method => 'test', service => 'test');

for (1 .. 2) {
    my $t1 = Yandex::Trace::new_profile('sleep1');
    test_sleep(61);
    undef $t1;
    if ($_ == 2) {
        my $r = get_last_log();
        ok(scalar @{$r->[14]->{profile}} == 1, "auto flush");
        ok($r->[$INDEX->{CHUNK_NUM}] == 1, "chunk num");
    }
}
undef $trace;
my $r = get_last_log();
ok(scalar @{$r->[14]->{profile}} == 1, "destructor flush");
ok($r->[$INDEX->{CHUNK_NUM}] == 2, "chunk num (2)");



done_testing();

