#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::MockTime qw(:all);
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;
use Path::Tiny;

use lib::abs '../lib';
BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };
do(lib::abs::path('.')."/_test_common.pl");

mock_hires();
set_fixed_time(time);
my $cwd = lib::abs::path('.');

$Yandex::Trace::LOG_OPTIONS = {
    log_file_name => 'trace.log',
};

my $logs = `$cwd/script/fork.pl`;
my ($child, $fork) = grep { length } map { chomp; $_ } split /\n/, $logs;
# diag("child = $child, fork = $fork");
ok($child =~ /^child: /, "got child log");
$child =~ s!^child: !!g;
ok(-f $child, "child log exists");
ok(-f $fork, "parent log exists");

my $child_str = path($child)->slurp_utf8();
my (undef, undef, $child_json) = split /\s+/, $child_str, 3;
my $child_data = from_json($child_json);
my $child_profile = $child_data->[14]->{profile};
ok(scalar @$child_profile == 1, "correct number of child profile");
ok($child_profile->[0]->[0] eq 'child_sleep', "correct child func");

my $child_service = $child_data->[14]->{services};
ok(scalar @$child_service == 0, "service from parent process does not shows in child");

my $parent_str = path($fork)->slurp_utf8();
my @parent_data = map { my (undef,undef, $data) = split /\s+/, $_,3; from_json($data) } split /\n/, $parent_str;
ok(scalar @parent_data == 2, "1 line for child and fork");

my $fork_profile = $parent_data[0]->[14]->{profile};
my $parent_profile = $parent_data[1]->[14]->{profile};

my $parent_service = $parent_data[1]->[14]->{services};
ok(scalar @$parent_service == 1, "service data in parent process");

ok(scalar @{$fork_profile} == 1, "correct number of profile in fork log");
ok(scalar @{$parent_profile} == 2, "correct number of profile in parent log");



done_testing();

