#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use Test::More;
use Test::Deep;
use lib::abs('../lib');
use Path::Tiny;
use JSON;
use Yandex::Trace qw//;

do(lib::abs::path('.')."/_test_common.pl");

my $cmd = lib::abs::path('.')."/script/example.pl";
my $log_file = `$cmd`;
chomp $log_file;
my $log = path($log_file)->slurp_utf8;
my ($date, $time, $json) = split /\s+/, $log, 3;
my $data = from_json($json);
ok($data->[0] == 3, "format_id");
ok(defined $data->[14]->{profile}, "profile written");
ok($data->[14]->{profile}->[0]->[0] eq "test_func", "correct profile data");

my ($test_pod) = (path($cmd)->slurp_utf8() =~ /=head1 TEST_DATA(.+?)=cut/ms);

my $test_data = from_json($test_pod);

for my $field (qw/DATE_TIME PID TRACE_ID PARENT_ID SPAN_ID SPAN_ELA HOSTNAME/) {
    # выкидываем поля которые меняются от запуска к запуску
    # TODO: научиться подделывать значения в example.pl чтобы вывод был всегда идентичный:
    # фиктивное время, зафиксировать rand() и подделывать $$ (либо подменять generate_traceid()
    $test_data->[$Yandex::Trace::INDEX->{$field}] = $data->[$Yandex::Trace::INDEX->{$field}] = undef;
}
$test_data->[$Yandex::Trace::INDEX->{DATA}]->{times} = $data->[$Yandex::Trace::INDEX->{DATA}]->{times} = undef;

cmp_deeply($test_data, $data, "expected log data");

done_testing();


