#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::Deep;
use Test::MockTime qw(:all);
use List::Util qw/first/;
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

mock_hires();
set_fixed_time(time);

my $trace = Yandex::Trace->new(method => 'test', service => 'test');

test_sleep(5);

$trace->mark('some event');

$trace->flush();

cmp_deeply($trace->{marks}, [], "marks cleared on flush");

my $r = get_last_log();
my $marks = $r->[$INDEX->{DATA}]->{marks};
ok(ref $marks eq 'ARRAY', "marks is array");
ok(scalar @$marks == 1, "mark in log");
ok($marks->[0]->[0] == 5, "mark start time");
ok($marks->[0]->[1] eq 'some event', "mark message");


done_testing();

