#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::MockTime qw(:all);
use List::Util qw/first/;
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

mock_hires();
set_fixed_time(time);

my $EPS = 0.001;

my $trace = Yandex::Trace->new(method => 'test', service => 'test');

my $t = $trace->new_profile('sleep1');
test_sleep(2);
undef $t;
undef $trace;

my $res = get_last_log();
ok(_all_ela($res) == 2, "profile ela ok");


$trace = Yandex::Trace->new(method => 'test2', service => 'test');
$t = $trace->new_profile('sleep2');
test_sleep(4);
undef $t;
$trace->flush();
$res = get_last_log();
ok(_all_ela($res) == 4, "profile and flush()");
undef $trace;

$trace = Yandex::Trace->new(method => 'test3', service => 'test');
f1();
f1();
f2();
$trace->flush();
$res = get_last_log();
my $pr_f1 = first { $_->[$PROFILE_INDEX->{FUNC}] eq 'f1' } @{$res->[14]->{profile}};
ok($pr_f1->[$PROFILE_INDEX->{OBJ_NUM}] == 0, 'obj_num');
ok($pr_f1->[$PROFILE_INDEX->{CALLS}] == 2, 'calls');

$trace = Yandex::Trace->new(method => 'test_nested', service => 'test');

my $p1 = Yandex::Trace::new_profile('p1');
test_sleep(1);
my $p2 = Yandex::Trace::new_profile('p2');
test_sleep(1);
undef $p2;
$trace->flush();

$res = get_last_log();
ok(scalar @{$res->[14]->{profile}} == 1, "not completed parent profile not removed");
undef $p1;
undef $trace;
$res = get_last_log();
ok(scalar @{$res->[14]->{profile}} == 1, "parent profile made it to the log");


{
my $trace = Yandex::Trace->new(method => 'test_grand_parent', service => 'test');

my $p1 = Yandex::Trace::new_profile('p1');
test_sleep(1);
my $p2 = Yandex::Trace::new_profile('p2');
test_sleep(1);
my $p3 = Yandex::Trace::new_profile('p3');
test_sleep(1);
undef $p3;
my $p4 = Yandex::Trace::new_profile('p4');
test_sleep(1);
undef $p4;
undef $p2;
$trace->flush();
my $res = get_last_log();
my ($p2_stat) = grep { $_->[0] eq 'p2' } @{$res->[14]->{profile}};
ok($p2_stat->[$PROFILE_INDEX->{CHILDS_ELA}] == 2, "grandparent profile gets childs_ela from grandchildren");

}


done_testing();

#####

sub _all_ela
{
    return shift->[14]->{profile}->[0]->[2];
}

sub _childs_ela
{
    return shift->[14]->{profile}->[0]->[3];
}

sub f1
{
    my $t = Yandex::Trace::new_profile('f1');
    test_sleep(1);
    f2();
    f3();
}

sub f2
{
    my $t = Yandex::Trace::new_profile('f2');
    test_sleep(2);
    f3();
}

sub f3
{
    my $t = Yandex::Trace::new_profile('f3');
    test_sleep(3);
}

